/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.function.Consumer;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5562;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1937.class})
public class LevelMixin {
    @Overwrite
    public <T extends class_1297> void method_18472(Consumer<T> consumer, T entity) {
        try {
            if (Props.notProcessing) {
                consumer.accept(entity);
            } else {
                if (Props.entityDepth < 0) {
                    Props.entityDepth = Thread.currentThread().getStackTrace().length - 1;
                }
                if (this instanceof class_3218) {
                    Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().process(entity);
                    Props.currentTarget.set(data2);
                    long start = System.nanoTime();
                    consumer.accept(entity);
                    data2.setTime(System.nanoTime() - start + data2.getTime());
                    Props.currentTarget.set(null);
                    data2.setTicks(data2.getTicks() + 1);
                } else {
                    consumer.accept(entity);
                }
            }
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Ticking entity");
            class_129 crashReportCategory = crashReport.method_562("Entity being ticked");
            entity.method_5819(crashReportCategory);
            throw new class_148(crashReport);
        }
    }

    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TickingBlockEntity;tick()V"))
    public final void redirectTick(class_5562 blockEntity) {
        if (Props.notProcessing) {
            blockEntity.method_31703();
        } else {
            if (Props.blockEntityDepth < 0) {
                Props.blockEntityDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            if (this instanceof class_3218) {
                Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processBlockEntity(blockEntity, (class_1937)this);
                Props.currentTarget.set(data2);
                long start = System.nanoTime();
                blockEntity.method_31703();
                data2.setTime(System.nanoTime() - start + data2.getTime());
                Props.currentTarget.set(null);
                data2.setTicks(data2.getTicks() + 1);
            } else {
                blockEntity.method_31703();
            }
        }
    }
}

