/*
 * Decompiled with CFR 0.152.
 */
package gln;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

final class MemoryTextDecoding {
    private MemoryTextDecoding() {
    }

    static String decodeASCII(long buffer2, int length, int offset) {
        if (length <= 0) {
            return "";
        }
        char[] chars = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            chars[i2] = (char)MemoryUtil.memGetByte((long)(buffer2 + (long)offset + (long)i2));
        }
        return new String(chars);
    }

    static String decodeUTF8(long buffer2, int length, int offset) {
        byte c;
        int position;
        if (length <= 0) {
            return "";
        }
        char[] string = new char[length];
        int i2 = 0;
        int limit = offset + length;
        for (position = offset; position < limit && (c = MemoryUtil.memGetByte((long)(buffer2 + (long)position))) >= 0; ++position) {
            string[i2++] = (char)c;
        }
        while (position < limit) {
            byte b2;
            byte b1;
            byte b0;
            if (0 <= (b0 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++)))) {
                string[i2++] = (char)b0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                b1 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                MemoryTextDecoding.checkMalformed2(b1);
                string[i2++] = (char)(b0 << 6 ^ b1 ^ 0xF80);
                continue;
            }
            if (b0 >> 4 == -2) {
                b1 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                b2 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                MemoryTextDecoding.checkMalformed3(b0, b1, b2);
                string[i2++] = MemoryTextDecoding.checkSurrogate((char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80)));
                continue;
            }
            if (b0 >> 3 == -2) {
                b1 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                b2 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                byte b3 = MemoryUtil.memGetByte((long)(buffer2 + (long)position++));
                int cp = b0 << 18 ^ b1 << 12 ^ b2 << 6 ^ (b3 ^ 0x381F80);
                MemoryTextDecoding.checkMalformed4(b1, b2, b3, cp);
                string[i2++] = (char)((cp >>> 10) + 55296 - 64);
                string[i2++] = (char)((cp & 0x3FF) + 56320);
                continue;
            }
            if (!Checks.DEBUG) continue;
            throw new RuntimeException("Malformed character sequence");
        }
        return new String(string, 0, i2);
    }

    private static void checkMalformed2(int b1) {
        if (Checks.DEBUG && (b1 & 0xC0) != 128) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    private static void checkMalformed3(int b0, int b1, int b2) {
        if (Checks.DEBUG && (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128)) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    private static char checkSurrogate(char c) {
        if (Checks.DEBUG && '\ud800' <= c && c <= '\udfff') {
            throw new RuntimeException("Malformed character sequence");
        }
        return c;
    }

    private static void checkMalformed4(int b1, int b2, int b3, int cp) {
        if (Checks.DEBUG && ((b1 & 0xC0) != 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(cp))) {
            throw new RuntimeException("Malformed character sequence");
        }
    }

    static String decodeUTF16(ByteBuffer buffer2, int length, int offset) {
        if (length <= 0) {
            return "";
        }
        return MemoryUtil.memCharBuffer((long)(MemoryUtil.memAddress((ByteBuffer)buffer2) + (long)offset), (int)length).toString();
    }
}

