/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageReader;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public final class TIFFImageReaderSpi
extends ImageReaderSpiBase {
    public TIFFImageReaderSpi() {
        super(new TIFFProviderInfo());
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        ImageReaderSpi imageReaderSpi = IIOUtil.lookupProviderByName(serviceRegistry, "com.sun.imageio.plugins.tiff.TIFFImageReaderSpi", ImageReaderSpi.class);
        if (imageReaderSpi != null && imageReaderSpi.getVendorName() != null && (imageReaderSpi.getVendorName().startsWith("Apple") || imageReaderSpi.getVendorName().startsWith("Oracle"))) {
            serviceRegistry.setOrdering(clazz, this, imageReaderSpi);
        }
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return TIFFImageReaderSpi.canDecodeAs(object, 42);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canDecodeAs(Object object, int n) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            ByteOrder byteOrder;
            block11: {
                byte[] byArray = new byte[2];
                imageInputStream.readFully(byArray);
                byteOrder = imageInputStream.getByteOrder();
                try {
                    if (byArray[0] == 73 && byArray[1] == 73) {
                        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                        break block11;
                    }
                    if (byArray[0] == 77 && byArray[1] == 77) {
                        imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
                        break block11;
                    }
                    boolean bl = false;
                    imageInputStream.setByteOrder(byteOrder);
                    return bl;
                }
                catch (Throwable throwable) {
                    imageInputStream.setByteOrder(byteOrder);
                    throw throwable;
                }
            }
            boolean bl = imageInputStream.readUnsignedShort() == n;
            imageInputStream.setByteOrder(byteOrder);
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public TIFFImageReader createReaderInstance(Object object) {
        return new TIFFImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Aldus/Adobe Tagged Image File Format (TIFF) image reader";
    }
}

