/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TextField
extends Widget {
    public class_2561 component = class_2585.field_24366;
    private class_5348[] formattedText = new class_5348[0];
    public int textFlags = 0;
    public int minWidth = 0;
    public int maxWidth = 5000;
    public int textSpacing = 10;
    public float scale = 1.0f;
    public Color4I textColor = Icon.EMPTY;
    public boolean trim = false;

    public TextField(Panel panel) {
        super(panel);
    }

    public TextField addFlags(int flags) {
        this.textFlags |= flags;
        return this;
    }

    public TextField setMinWidth(int width) {
        this.minWidth = width;
        return this;
    }

    public TextField setMaxWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    public TextField setColor(Color4I color) {
        this.textColor = color;
        return this;
    }

    public TextField setScale(float s) {
        this.scale = s;
        return this;
    }

    public TextField setSpacing(int s) {
        this.textSpacing = s;
        return this;
    }

    public TextField setTrim() {
        this.trim = true;
        return this;
    }

    public TextField setText(class_2561 txt) {
        Theme theme = this.getGui().getTheme();
        this.formattedText = this.trim ? new class_5348[]{theme.trimStringToWidth((class_5348)new class_2585("").method_10852(txt), this.maxWidth)} : theme.listFormattedStringToWidth((class_5348)new class_2585("").method_10852(txt), this.maxWidth).toArray(new class_5348[0]);
        return this.resize(theme);
    }

    public TextField setText(String txt) {
        return this.setText((class_2561)new class_2585(txt));
    }

    public TextField resize(Theme theme) {
        this.setWidth(0);
        for (class_5348 s : this.formattedText) {
            this.setWidth(Math.max(this.width, (int)((float)theme.getStringWidth(s) * this.scale)));
        }
        this.setWidth(class_3532.method_15340((int)this.width, (int)this.minWidth, (int)this.maxWidth));
        this.setHeight((int)((float)(Math.max(1, this.formattedText.length) * this.textSpacing - (this.textSpacing - theme.getFontHeight() + 1)) * this.scale));
        return this;
    }

    @Override
    public void addMouseOverText(TooltipList list) {
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(matrixStack, theme, x, y, w, h);
        if (this.formattedText.length != 0) {
            boolean centered = Bits.getFlag(this.textFlags, 4);
            boolean centeredV = Bits.getFlag(this.textFlags, 32);
            Color4I col = this.textColor;
            if (col.isEmpty()) {
                col = theme.getContentColor(WidgetType.mouseOver(Bits.getFlag(this.textFlags, 16)));
            }
            int tx = x + (centered ? w / 2 : 0);
            int ty = y + (centeredV ? (h - theme.getFontHeight()) / 2 : 0);
            if (this.scale == 1.0f) {
                for (int i = 0; i < this.formattedText.length; ++i) {
                    theme.drawString(matrixStack, this.formattedText[i], tx, ty + i * this.textSpacing, col, this.textFlags);
                }
            } else {
                matrixStack.method_22903();
                matrixStack.method_22904((double)tx, (double)ty, 0.0);
                matrixStack.method_22905(this.scale, this.scale, 1.0f);
                for (int i = 0; i < this.formattedText.length; ++i) {
                    theme.drawString(matrixStack, this.formattedText[i], 0.0f, i * this.textSpacing, col, this.textFlags);
                }
                matrixStack.method_22909();
            }
        }
    }

    public class_2583 getComponentStyleAt(Theme theme, int mouseX, int mouseY) {
        int line = (mouseY - this.getY()) / theme.getFontHeight();
        if (line >= 0 && line < this.formattedText.length) {
            int xStart;
            boolean centered = Bits.getFlag(this.textFlags, 4);
            int textWidth = theme.getFont().method_27525(this.formattedText[line]);
            int n = xStart = centered ? this.getX() + (this.width - textWidth) / 2 : this.getX();
            if (mouseX >= xStart && mouseX <= xStart + textWidth) {
                return theme.getFont().method_27527().method_27489(this.formattedText[line], mouseX - xStart);
            }
        }
        return null;
    }
}

