/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1041;
import net.minecraft.class_1087;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final BaseScreen BLANK_GUI = new BaseScreen(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
    }

    public static void playSound(class_3414 event, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)pitch));
    }

    public static void drawTexturedRect(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        RenderSystem.enableTexture();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        GuiHelper.addRectToBufferWithUV(matrixStack, buffer, x, y, w, h, col, u0, v0, u1, v1);
        tesselator.method_1350();
    }

    public static void addRectToBuffer(class_4587 matrixStack, class_287 buffer, int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        class_1159 m = matrixStack.method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_1344();
    }

    public static void addRectToBufferWithUV(class_4587 matrixStack, class_287 buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (w <= 0 || h <= 0) {
            return;
        }
        class_1159 m = matrixStack.method_23760().method_23761();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u0, v1).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913(u1, v1).method_1344();
        buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u1, v0).method_1344();
        buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913(u0, v0).method_1344();
    }

    public static void drawHollowRect(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(matrixStack, x, y, w, h);
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableTexture();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, w, 1, col);
        }
        tesselator.method_1350();
        RenderSystem.enableTexture();
    }

    public static void drawRectWithShade(class_4587 matrixStack, int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableTexture();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 1, 1, col);
        tesselator.method_1350();
        RenderSystem.enableTexture();
    }

    public static void drawItem(class_4587 poseStack, class_1799 stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.method_7960()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        class_1087 bakedModel = itemRenderer.method_4019(stack, null, (class_1309)mc.field_1724, hash);
        class_310.method_1551().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34425(poseStack.method_23760().method_23761());
        modelViewStack.method_22905(1.0f, -1.0f, 1.0f);
        modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flatLight = !bakedModel.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_809.class_811.field_4317, false, new class_4587(), (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            class_289 t = class_289.method_1348();
            class_327 font = mc.field_1772;
            if (stack.method_7947() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.method_7947()) : text;
                poseStack.method_22903();
                poseStack.method_22904(9.0 - (double)font.method_1727(s), 1.0, 20.0);
                font.method_27521(s, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.method_23760().method_23761(), (class_4597)bufferSource, false, 0, 0xF000F0);
                bufferSource.method_22993();
                poseStack.method_22909();
            }
            if (stack.method_31578()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableBlend();
                int barWidth = stack.method_31579();
                int barColor = stack.method_31580();
                GuiHelper.draw(poseStack, t, -6, 5, 13, 2, 0, 0, 0, 255);
                GuiHelper.draw(poseStack, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.field_1724 == null ? 0.0f : mc.field_1724.method_7357().method_7905(stack.method_7909(), mc.method_1488());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GuiHelper.draw(poseStack, t, -8, class_3532.method_15375((float)(16.0f * (1.0f - cooldown))) - 8, 16, class_3532.method_15386((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(class_4587 matrixStack, class_289 t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        class_1159 m = matrixStack.method_23760().method_23761();
        class_287 renderer = t.method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        t.method_1350();
    }

    public static void pushScissor(class_1041 screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(class_1041 screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static String clickEventToString(@Nullable class_2558 event) {
        if (event == null) {
            return "";
        }
        return switch (event.method_10845()) {
            case class_2558.class_2559.field_11749, class_2558.class_2559.field_11748 -> event.method_10844();
            case class_2558.class_2559.field_11746 -> "file:" + event.method_10844();
            case class_2558.class_2559.field_11750 -> "command:" + event.method_10844();
            case class_2558.class_2559.field_11745 -> "suggest_command:" + event.method_10844();
            default -> "";
        };
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(class_1799 stack, List<class_2561> list, @Nullable class_2561 prefix) {
        List tooltip = stack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
        list.add((class_2561)(prefix == null ? ((class_2561)tooltip.get(0)).method_27661().method_27692(stack.method_7932().field_8908) : prefix.method_27661().method_10852((class_2561)tooltip.get(0))));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add((class_2561)new class_2585("").method_27692(class_124.field_1080).method_10852((class_2561)tooltip.get(i)));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(class_1041 screen) {
            double scale = screen.method_4495();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.method_4502() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

