/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ContextMenu
extends Panel {
    private static final int MARGIN = 3;
    public final List<ContextMenuItem> items;
    public boolean hasIcons;
    private int nColumns;
    private int columnWidth;

    public ContextMenu(Panel panel, List<ContextMenuItem> i) {
        super(panel);
        this.items = i;
        this.hasIcons = this.items.stream().anyMatch(item -> !item.icon.isEmpty());
    }

    @Override
    public void addWidgets() {
        this.items.forEach(item -> this.add(item.createWidget(this)));
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean pressed = super.mousePressed(button);
        if (!pressed && !this.isMouseOver()) {
            this.closeContextMenu();
            return true;
        }
        return pressed;
    }

    @Override
    public void alignWidgets() {
        this.setWidth(0);
        int totalHeight = 0;
        int maxWidth = 0;
        for (Widget widget : this.widgets) {
            maxWidth = Math.max(maxWidth, widget.width);
            totalHeight += widget.height + 1;
        }
        this.nColumns = this.parent.getScreen().method_4502() > 0 ? (totalHeight += 6) / this.parent.getScreen().method_4502() + 1 : 1;
        int nRows = this.nColumns == 1 ? this.widgets.size() : this.widgets.size() / this.nColumns + 1;
        this.columnWidth = maxWidth + 6;
        this.setWidth(this.columnWidth * this.nColumns);
        int yPos = 3;
        int prevCol = 0;
        int maxHeight = 0;
        for (int i = 0; i < this.widgets.size(); ++i) {
            int col = i / nRows;
            if (prevCol != col) {
                yPos = 3;
                prevCol = col;
            }
            Widget widget = (Widget)this.widgets.get(i);
            widget.setPosAndSize(3 + this.columnWidth * col, yPos, maxWidth, widget.height);
            maxHeight = Math.max(maxHeight, yPos + widget.height + 1);
            yPos += widget.height + 1;
        }
        this.setHeight(maxHeight + 3 - 1);
    }

    @Override
    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(matrixStack, x, y, w, h);
    }

    @Override
    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 900.0);
        super.draw(matrixStack, theme, x, y, w, h);
        for (int i = 1; i < this.nColumns; ++i) {
            Color4I.WHITE.withAlpha(130).draw(matrixStack, x + this.columnWidth * i, y + 3, 1, this.height - 6);
        }
        matrixStack.method_22909();
    }

    public static class CSeperator
    extends Button {
        public CSeperator(Panel panel) {
            super(panel);
            this.setHeight(5);
        }

        @Override
        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            Color4I.WHITE.withAlpha(130).draw(matrixStack, x + 2, y + 2, this.parent.width - 10, 1);
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }

    public static class CButton
    extends Button {
        public final ContextMenu contextMenu;
        public final ContextMenuItem item;

        public CButton(ContextMenu panel, ContextMenuItem i) {
            super(panel, i.title, i.icon);
            this.contextMenu = panel;
            this.item = i;
            this.setSize(panel.getGui().getTheme().getStringWidth((class_5348)this.item.title) + (this.contextMenu.hasIcons ? 14 : 4), 12);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            this.item.addMouseOverText(list);
        }

        @Override
        public WidgetType getWidgetType() {
            return this.item.enabled.getAsBoolean() ? super.getWidgetType() : WidgetType.DISABLED;
        }

        @Override
        public void drawIcon(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            this.item.drawIcon(matrixStack, theme, x, y, w, h);
        }

        @Override
        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            if (this.contextMenu.hasIcons) {
                this.drawIcon(matrixStack, theme, x + 1, y + 2, 8, 8);
                theme.drawString(matrixStack, this.getTitle(), x + 11, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            } else {
                theme.drawString(matrixStack, this.getTitle(), x + 2, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.item.yesNoText.getString().isEmpty()) {
                this.item.onClicked(this.contextMenu, button);
            } else {
                this.getGui().openYesNo(this.item.yesNoText, (class_2561)new class_2585(""), () -> this.item.onClicked(this.contextMenu, button));
            }
        }
    }
}

