/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_5321;

public class XZ {
    public final int x;
    public final int z;

    public static XZ of(int x, int z) {
        return new XZ(x, z);
    }

    public static XZ of(long singleLong) {
        return XZ.of((int)singleLong, (int)(singleLong >> 32));
    }

    public static XZ of(class_1923 pos) {
        return XZ.of(pos.field_9181, pos.field_9180);
    }

    public static XZ chunkFromBlock(int x, int z) {
        return XZ.of(x >> 4, z >> 4);
    }

    public static XZ chunkFromBlock(class_2382 pos) {
        return XZ.chunkFromBlock(pos.method_10263(), pos.method_10260());
    }

    public static XZ regionFromChunk(int x, int z) {
        return XZ.of(x >> 5, z >> 5);
    }

    public static XZ regionFromChunk(class_1923 p) {
        return XZ.of(p.field_9181 >> 5, p.field_9180 >> 5);
    }

    public static XZ regionFromBlock(int x, int z) {
        return XZ.of(x >> 9, z >> 9);
    }

    public static XZ regionFromBlock(class_2382 pos) {
        return XZ.regionFromBlock(pos.method_10263(), pos.method_10260());
    }

    private XZ(int _x, int _z) {
        this.x = _x;
        this.z = _z;
    }

    public int hashCode() {
        int x1 = 1664525 * this.x + 1013904223;
        int z1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return x1 ^ z1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XZ)) {
            return false;
        }
        XZ p = (XZ)o;
        return this.x == p.x && this.z == p.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public ChunkDimPos dim(class_5321<class_1937> type) {
        return new ChunkDimPos(type, this.x, this.z);
    }

    public ChunkDimPos dim(class_1937 world) {
        return this.dim((class_5321<class_1937>)world.method_27983());
    }

    public XZ offset(int ox, int oz) {
        return XZ.of(this.x + ox, this.z + oz);
    }

    public long toLong() {
        return class_1923.method_8331((int)this.x, (int)this.z);
    }

    public String toRegionString() {
        return String.format("%05X-%05X", this.x + 60000, this.z + 60000);
    }
}

