/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class StringConfig
extends ConfigFromString<String> {
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final Pattern pattern;

    public StringConfig(@Nullable Pattern p) {
        this.pattern = p;
        this.defaultValue = "";
        this.value = "";
    }

    public StringConfig() {
        this(null);
    }

    @Override
    public Color4I getColor(@Nullable String v) {
        return COLOR;
    }

    @Override
    public boolean parse(@Nullable Consumer<String> callback, String string) {
        if (this.pattern == null || this.pattern.matcher(string).matches()) {
            if (callback != null) {
                callback.accept(string);
            }
            return true;
        }
        return false;
    }

    @Override
    public class_2561 getStringForGUI(@Nullable String v) {
        return v == null ? NULL_TEXT : new class_2585("\"" + v + "\"");
    }

    @Override
    public void addInfo(TooltipList list) {
        if (this.value != null && !((String)this.value).equals(this.defaultValue)) {
            list.add((class_2561)new class_2588("config.group.value").method_27693(": ").method_27692(class_124.field_1075).method_10852((class_2561)new class_2585("\"" + (String)this.value + "\"").method_27692(class_124.field_1068)));
        }
        super.addInfo(list);
        if (this.pattern != null) {
            list.add(StringConfig.info("Regex", this.pattern.pattern()));
        }
    }
}

