/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.fabric;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_437;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.core.ClientCore;
import nx.pingwheel.common.helper.ClientCommandBuilder;
import nx.pingwheel.common.networking.PingLocationPacketS2C;
import nx.pingwheel.common.networking.UpdateChannelPacketC2S;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.fabric.event.GameOverlayRenderCallback;

@Environment(value=EnvType.CLIENT)
public class Client
implements ClientModInitializer {
    public static final class_2960 RELOAD_LISTENER_ID = new class_2960("ping-wheel", "reload-listener");

    public void onInitializeClient() {
        ClientGlobal.ConfigHandler = new ConfigHandler<ClientConfig>(ClientConfig.class, FabricLoader.getInstance().getConfigDir().resolve("ping-wheel.json"));
        ClientGlobal.ConfigHandler.load();
        class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)ClientGlobal.PING_SOUND_ID, (Object)ClientGlobal.PING_SOUND_EVENT);
        this.registerNetworkPackets();
        this.registerReloadListener();
        this.registerKeyBindings();
        ClientPlayConnectionEvents.JOIN.register((a, b, c) -> new UpdateChannelPacketC2S(ClientGlobal.ConfigHandler.getConfig().getChannel()).send());
        WorldRenderEvents.END.register(ctx -> ClientCore.onRenderWorld(ctx.matrixStack(), ctx.projectionMatrix(), ctx.tickDelta()));
        GameOverlayRenderCallback.START.register(ClientCore::onRenderGUI);
        ClientCommandManager.DISPATCHER.register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)response);
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)response);
            }
        }));
    }

    private void registerNetworkPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)PingLocationPacketS2C.ID, (a, b, packet, c) -> ClientCore.onPingLocation(packet));
    }

    private void registerReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return RELOAD_LISTENER_ID;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 helper, class_3300 resourceManager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
                return ResourceReloadListener.reloadTextures(helper, resourceManager, loadExecutor, applyExecutor);
            }
        });
    }

    private void registerKeyBindings() {
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_PING);
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_SETTINGS);
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_NAME_LABELS);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (ClientGlobal.KEY_BINDING_PING.method_1436()) {
                ClientCore.markLocation();
            }
            if (ClientGlobal.KEY_BINDING_SETTINGS.method_1436()) {
                ClientGlobal.Game.method_1507((class_437)new SettingsScreen());
            }
        });
    }
}

