/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.compat.Text;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.screen.SettingsScreen;
import org.apache.logging.log4j.util.TriConsumer;

public class ClientCommandBuilder {
    private ClientCommandBuilder() {
    }

    public static <S> LiteralArgumentBuilder<S> build(TriConsumer<CommandContext<S>, Boolean, class_5250> responseHandler) {
        UnaryOperator formatChannel = channel -> {
            if (channel.isEmpty()) {
                return Text.translatable("ping-wheel.command.channel.name.default", new Object[0]).getString();
            }
            return Text.translatable("ping-wheel.command.channel.name", channel).getString();
        };
        LiteralArgumentBuilder cmdChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"channel").executes(context -> {
            String currentChannel = ClientGlobal.ConfigHandler.getConfig().getChannel();
            responseHandler.accept((Object)context, (Object)true, (Object)Text.translatable("ping-wheel.command.channel.get.response", formatChannel.apply(currentChannel)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"channel_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String newChannel = (String)context.getArgument("channel_name", String.class);
            if (newChannel.length() > ClientConfig.MAX_CHANNEL_LENGTH) {
                responseHandler.accept((Object)context, (Object)false, (Object)Text.translatable("ping-wheel.command.channel.set.reject", ClientConfig.MAX_CHANNEL_LENGTH));
                return 0;
            }
            ClientGlobal.ConfigHandler.getConfig().setChannel(newChannel);
            ClientGlobal.ConfigHandler.save();
            responseHandler.accept((Object)context, (Object)true, (Object)Text.translatable("ping-wheel.command.channel.set.response", formatChannel.apply(newChannel)));
            return 1;
        }));
        LiteralArgumentBuilder cmdConfig = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").executes(context -> {
            ClientGlobal.Game.method_18858(() -> ClientGlobal.Game.method_1507((class_437)new SettingsScreen()));
            return 1;
        });
        Command helpCallback = context -> {
            BinaryOperator form = (command, key) -> Text.translatable("ping-wheel.command.help.format", command, Text.translatable(key, new Object[0])).getString();
            class_5250 output = Text.empty().method_27662();
            output.method_27693((String)form.apply("/pingwheel config", "ping-wheel.command.config.description"));
            output.method_27693("\n");
            output.method_27693((String)form.apply("/pingwheel channel", "ping-wheel.command.channel.get.description"));
            output.method_27693("\n");
            output.method_27693((String)form.apply("/pingwheel channel <channel_name>", "ping-wheel.command.channel.set.description"));
            responseHandler.accept((Object)context, (Object)true, (Object)output);
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(helpCallback);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"pingwheel").executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdConfig)).then((ArgumentBuilder)cmdChannel);
    }
}

