/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.handler;

import com.bawnorton.neruina.Neruina;
import com.bawnorton.neruina.config.Config;
import com.bawnorton.neruina.exception.DoNotHandleException;
import com.bawnorton.neruina.mixin.invoker.WorldChunkInvoker;
import com.bawnorton.neruina.thread.ConditionalRunnable;
import com.bawnorton.neruina.version.Version;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5558;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class NeruinaTickHandler {
    private static final Set<class_2586> ERRORED_BLOCK_ENTITIES = new HashSet<class_2586>();
    private static final Set<class_1297> ERRORED_ENTITIES = new HashSet<class_1297>();
    private static final Set<class_1799> ERRORED_ITEM_STACKS = new HashSet<class_1799>();
    private static final Set<ImmutablePair<class_2338, class_2680>> ERRORED_BLOCK_STATES = new HashSet<ImmutablePair<class_2338, class_2680>>();
    private static MinecraftServer server;

    public static void setServer(MinecraftServer server) {
        NeruinaTickHandler.server = server;
    }

    public static void safelyTickItemStack$notTheCauseOfTickLag(class_1799 instance, class_1937 world, class_1297 entity, int slot, boolean selected, Operation<Void> original) {
        block4: {
            try {
                if (NeruinaTickHandler.isErrored(instance)) {
                    return;
                }
                original.call(new Object[]{instance, world, entity, slot, selected});
            }
            catch (Throwable e) {
                if (!Config.getInstance().handleTickingItemStacks.booleanValue()) {
                    throw new DoNotHandleException(e, DoNotHandleException.Reason.ITEM_STACK_DISABLED);
                }
                class_2561 message = Version.translatableText("neruina.ticking.item_stack", instance.method_7909().method_7848().getString(), slot);
                Neruina.LOGGER.warn("Neruina Caught Exception", e);
                NeruinaTickHandler.addErrored(instance);
                if (!world.field_9236 || !(entity instanceof class_1657)) break block4;
                class_1657 player = (class_1657)entity;
                player.method_7353(Version.formatText(message), false);
            }
        }
    }

    public static void safelyTickPlayer$notTheCauseOfTickLag(class_3222 instance, Operation<Void> original) {
        try {
            original.call(new Object[]{instance});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingPlayers.booleanValue()) {
                throw new DoNotHandleException(e, DoNotHandleException.Reason.PLAYER_DISABLED);
            }
            NeruinaTickHandler.handleTickingPlayer(instance, e);
        }
    }

    public static void safelyTickBlockState$notTheCauseOfTickLag(class_2680 instance, class_3218 world, class_2338 pos, Object random, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(pos, instance)) {
                return;
            }
            original.call(new Object[]{instance, world, pos, random});
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingBlockStates.booleanValue()) {
                throw new DoNotHandleException(e, DoNotHandleException.Reason.BLOCK_STATE_DISABLED);
            }
            class_2561 message = Version.translatableText("neruina.ticking.block_state", instance.method_26204().method_9518(), pos.method_10263(), pos.method_10264(), pos.method_10260());
            Neruina.LOGGER.warn("Neruina Caught Exception", e);
            NeruinaTickHandler.addErrored(pos, instance);
            NeruinaTickHandler.messagePlayers(message);
        }
    }

    public static void safelyTickBlockEntity$notTheCauseOfTickLag(class_5558<? extends class_2586> instance, class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, Operation<Void> original) {
        block5: {
            try {
                if (NeruinaTickHandler.isErrored(blockEntity)) {
                    if (world.field_9236) {
                        return;
                    }
                    class_2818 chunk = world.method_8500(pos);
                    ((WorldChunkInvoker)chunk).invokeRemoveBlockEntityTicker(pos);
                    return;
                }
                original.call(new Object[]{instance, world, pos, state, blockEntity});
            }
            catch (Throwable e) {
                if (!Config.getInstance().handleTickingBlockEntities.booleanValue()) {
                    throw new DoNotHandleException(e, DoNotHandleException.Reason.BLOCK_ENTITY_DISABLED);
                }
                class_2561 message = Version.translatableText("neruina.ticking.block_entity", state.method_26204().method_9518(), pos.method_10263(), pos.method_10264(), pos.method_10260());
                Neruina.LOGGER.warn("Neruina Caught Exception", e);
                NeruinaTickHandler.addErrored(blockEntity);
                if (world.method_8608()) break block5;
                NeruinaTickHandler.messagePlayers(message);
            }
        }
    }

    public static <T extends class_1297> void safelyTickEntities$notTheCauseOfTickLag(Consumer<T> instance, T entity, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(entity)) {
                NeruinaTickHandler.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{instance, entity});
        }
        catch (DoNotHandleException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw new DoNotHandleException(e, DoNotHandleException.Reason.ENTITY_DISABLED);
            }
            NeruinaTickHandler.handleEntityTicking(entity, e);
        }
    }

    public static <T extends class_1297> void safelyTickEntities$notTheCauseOfTickLag(Consumer<T> consumer, T entity, class_1937 world, Object random, Operation<Void> original) {
        try {
            if (NeruinaTickHandler.isErrored(entity)) {
                NeruinaTickHandler.handleErroredEntity(entity);
                return;
            }
            original.call(new Object[]{consumer, entity, world, random});
        }
        catch (DoNotHandleException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!Config.getInstance().handleTickingEntities.booleanValue()) {
                throw new DoNotHandleException(e, DoNotHandleException.Reason.ENTITY_DISABLED);
            }
            NeruinaTickHandler.handleEntityTicking(entity, e);
        }
    }

    private static void handleErroredEntity(class_1297 entity) {
        try {
            if (entity instanceof class_1657) {
                return;
            }
            if (entity.method_5770().method_8608()) {
                return;
            }
            entity.method_5768();
            entity.method_5650(class_1297.class_5529.field_26998);
            entity.method_5670();
            NeruinaTickHandler.removeErrored(entity);
        }
        catch (Throwable e) {
            throw new DoNotHandleException(e);
        }
    }

    private static void handleEntityTicking(class_1297 entity, Throwable e) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            NeruinaTickHandler.handleTickingPlayer(player, e);
            return;
        }
        if (entity instanceof class_1657) {
            throw new DoNotHandleException(e);
        }
        class_243 pos = entity.method_19538();
        class_2561 message = Version.translatableText("neruina.ticking.entity", entity.method_5477().getString(), Math.floor(pos.method_10216()), Math.floor(pos.method_10214()), Math.floor(pos.method_10215()));
        Neruina.LOGGER.warn("Neruina Caught Exception", e);
        NeruinaTickHandler.addErrored(entity);
        if (!entity.method_5770().method_8608()) {
            NeruinaTickHandler.messagePlayers(message);
        }
    }

    private static void handleTickingPlayer(class_3222 player, Throwable e) {
        class_2561 message = Version.translatableText("neruina.ticking.player", player.method_5477().getString());
        Neruina.LOGGER.warn("Neruina Caught Exception", e);
        if (!player.method_5770().method_8608()) {
            if (!server.method_3816()) {
                throw new DoNotHandleException(e, DoNotHandleException.Reason.PLAYER_IN_SINGLEPLAYER);
            }
            NeruinaTickHandler.messagePlayers(message);
            player.field_13987.method_14367(Version.textOf(Version.translatableText("neruina.kick.message", new Object[0]).getString()));
        }
    }

    private static void messagePlayers(class_2561 message) {
        if (!Config.getInstance().broadcastErrors.booleanValue()) {
            return;
        }
        class_3324 playerManager = server.method_3760();
        ConditionalRunnable.create(() -> playerManager.method_14571().forEach(player -> player.method_7353(Version.formatText(message), false)), () -> playerManager.method_14574() >= 1);
    }

    public static boolean isErrored(class_2586 blockEntity) {
        if (ERRORED_BLOCK_ENTITIES.isEmpty()) {
            return false;
        }
        return ERRORED_BLOCK_ENTITIES.contains(blockEntity);
    }

    public static void addErrored(class_2586 blockEntity) {
        ERRORED_BLOCK_ENTITIES.add(blockEntity);
    }

    public static void removeErrored(class_2586 blockEntity) {
        ERRORED_BLOCK_ENTITIES.remove(blockEntity);
    }

    public static boolean isErrored(class_1297 entity) {
        if (ERRORED_ENTITIES.isEmpty()) {
            return false;
        }
        return ERRORED_ENTITIES.contains(entity);
    }

    public static void addErrored(class_1297 entity) {
        ERRORED_ENTITIES.add(entity);
    }

    public static void removeErrored(class_1297 entity) {
        ERRORED_ENTITIES.remove(entity);
    }

    public static boolean isErrored(class_1799 item) {
        if (ERRORED_ITEM_STACKS.isEmpty()) {
            return false;
        }
        return ERRORED_ITEM_STACKS.contains(item);
    }

    public static void addErrored(class_1799 item) {
        ERRORED_ITEM_STACKS.add(item);
    }

    public static boolean isErrored(class_2338 pos, class_2680 state) {
        if (ERRORED_BLOCK_STATES.isEmpty()) {
            return false;
        }
        return ERRORED_BLOCK_STATES.contains(new ImmutablePair((Object)pos, (Object)state));
    }

    public static void addErrored(class_2338 pos, class_2680 state) {
        ERRORED_BLOCK_STATES.add((ImmutablePair<class_2338, class_2680>)new ImmutablePair((Object)pos, (Object)state));
    }

    public static void removeErrored(class_2338 pos, class_2680 state) {
        ERRORED_BLOCK_STATES.remove(new ImmutablePair((Object)pos, (Object)state));
    }
}

