/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class ClaimedChunk
implements ClaimResult {
    public FTBChunksTeamData teamData;
    public final ChunkDimPos pos;
    public long time;
    public long forceLoaded;
    private long forceLoadExpiryTime;

    public ClaimedChunk(FTBChunksTeamData p, ChunkDimPos cp) {
        this.teamData = p;
        this.pos = cp;
        this.time = System.currentTimeMillis();
        this.forceLoaded = 0L;
        this.forceLoadExpiryTime = 0L;
    }

    public FTBChunksTeamData getTeamData() {
        return this.teamData;
    }

    public ChunkDimPos getPos() {
        return this.pos;
    }

    public long getTimeClaimed() {
        return this.time;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public void setClaimedTime(long t) {
        this.time = t;
        this.teamData.manager.clearForceLoadedCache();
        this.sendUpdateToAll();
    }

    public long getForceLoadedTime() {
        return this.forceLoaded;
    }

    public boolean isForceLoaded() {
        return this.forceLoaded > 0L;
    }

    public boolean isActuallyForceLoaded() {
        return this.isForceLoaded() && this.teamData.canForceLoadChunks();
    }

    @Override
    public void setForceLoadedTime(long time) {
        this.forceLoaded = time;
        this.teamData.manager.clearForceLoadedCache();
        this.sendUpdateToAll();
        class_3218 level = this.teamData.manager.getMinecraftServer().method_3847(this.pos.dimension);
        if (level != null) {
            if (this.forceLoaded > 0L) {
                level.method_8497(this.pos.x, this.pos.z);
            }
            class_3215 cache = level.method_14178();
            class_1923 chunkPos = this.pos.getChunkPos();
            if (cache != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", this.teamData.getTeamId(), chunkPos.field_9181, chunkPos.field_9180, this.forceLoaded > 0L);
                cache.method_17298(false);
            } else {
                FTBChunks.LOGGER.warn("Failed to force-load chunk " + this.pos.x + ", " + this.pos.z + " @ " + this.pos.dimension.method_29177() + "!");
            }
        }
    }

    public boolean canEntitySpawn(class_1297 entity) {
        return true;
    }

    public boolean allowExplosions() {
        return this.teamData.allowExplosions();
    }

    public void sendUpdateToAll() {
        SendChunkPacket packet = new SendChunkPacket((class_5321<class_1937>)this.pos.dimension, this.teamData.getTeamId(), new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, this));
        ChunkSendingUtils.sendChunkToAll(this.teamData.manager.getMinecraftServer(), this.teamData, packet);
    }

    public void unload(class_2168 source) {
        if (this.isForceLoaded()) {
            this.setForceLoadedTime(0L);
            ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNLOAD.invoker()).after(source, this);
            this.teamData.save();
            this.forceLoadExpiryTime = 0L;
        }
    }

    public void unclaim(class_2168 source, boolean sync) {
        this.unload(source);
        this.teamData.manager.unregisterClaim(this.pos);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNCLAIM.invoker()).after(source, this);
        this.teamData.save();
        if (sync) {
            SendChunkPacket packet = new SendChunkPacket((class_5321<class_1937>)this.pos.dimension, class_156.field_25140, new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, null));
            packet.sendToAll(source.method_9211());
        }
    }

    public long getForceLoadExpiryTime() {
        return this.forceLoadExpiryTime;
    }

    public void setForceLoadExpiryTime(long forceLoadExpiryTime) {
        this.forceLoadExpiryTime = forceLoadExpiryTime;
        this.teamData.save();
    }

    public boolean hasExpired(long now) {
        return this.forceLoadExpiryTime > 0L && this.forceLoadExpiryTime < now;
    }

    public String toString() {
        return "[ " + this.pos.toString() + " - " + this.teamData + " ]";
    }

    public class_2487 serializeNBT() {
        SNBTCompoundTag o = new SNBTCompoundTag();
        o.singleLine();
        o.method_10569("x", this.getPos().x);
        o.method_10569("z", this.getPos().z);
        o.method_10544("time", this.getTimeClaimed());
        if (this.isForceLoaded()) {
            o.method_10544("force_loaded", this.getForceLoadedTime());
        }
        if (this.getForceLoadExpiryTime() > 0L) {
            o.method_10544("expiry_time", this.getForceLoadExpiryTime());
        }
        return o;
    }

    public static ClaimedChunk deserializeNBT(FTBChunksTeamData data, class_5321<class_1937> dimKey, class_2487 tag) {
        ClaimedChunk chunk = new ClaimedChunk(data, new ChunkDimPos(dimKey, tag.method_10550("x"), tag.method_10550("z")));
        chunk.time = tag.method_10537("time");
        chunk.forceLoaded = tag.method_10537("force_loaded");
        chunk.forceLoadExpiryTime = tag.method_10537("expiry_time");
        return chunk;
    }
}

