/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.integration.MapIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class MapIconWidget
extends Widget {
    public final MapIcon mapIcon;
    public final RegionMapPanel regionMapPanel;

    public MapIconWidget(RegionMapPanel panel, MapIcon m) {
        super((Panel)panel);
        this.mapIcon = m;
        this.regionMapPanel = panel;
    }

    public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.width > 0 && this.height > 0) {
            this.updatePosition(this.regionMapPanel.getPartialTicks());
            this.mapIcon.draw(MapType.LARGE_MAP, matrixStack, x, y, w, h, false, 255);
        }
    }

    public void addMouseOverText(TooltipList list) {
        if (this.width > 0 && this.height > 0 && !list.shouldRender()) {
            this.mapIcon.addTooltip(list);
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && this.width > 0 && this.height > 0 && this.mapIcon.mousePressed(this.regionMapPanel.largeMap, button)) {
            return true;
        }
        return super.mousePressed(button);
    }

    public boolean keyPressed(Key key) {
        if (this.isMouseOver() && this.width > 0 && this.height > 0 && this.mapIcon.keyPressed(this.regionMapPanel.largeMap, key)) {
            return true;
        }
        return super.keyPressed(key);
    }

    public void updatePosition(float delta) {
        int z = this.regionMapPanel.largeMap.getRegionButtonSize();
        class_243 pos = this.mapIcon.getPos(delta);
        double qx = pos.field_1352 / 512.0;
        double qy = pos.field_1350 / 512.0;
        double x = (qx - (double)this.regionMapPanel.regionMinX) * (double)z - (double)this.width / 2.0;
        double y = (qy - (double)this.regionMapPanel.regionMinZ) * (double)z - (this.mapIcon.isIconOnEdge(MapType.LARGE_MAP, false) ? (double)this.height : (double)this.height / 2.0);
        this.setPos(class_3532.method_15357((double)x), class_3532.method_15357((double)y));
    }
}

