/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class LargeMapScreen
extends BaseScreen {
    public Color4I backgroundColor = Color4I.rgb((int)0x202225);
    public RegionMapPanel regionPanel = new RegionMapPanel(this);
    public int zoom = 256;
    public MapDimension dimension;
    public int scrollWidth = 0;
    public int scrollHeight = 0;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed = 0;
    public boolean movedToPlayer = false;
    public Button claimChunksButton;
    public Button dimensionButton;
    public Button waypointManagerButton;
    public Button settingsButton;
    public Button serverSettingsButton;
    public Button clearDeathpointsButton;
    private boolean needIconRefresh;
    private final int minZoom;

    public LargeMapScreen() {
        MapDimension dim = MapDimension.getCurrent();
        if (dim == null) {
            FTBChunks.LOGGER.warn("Closed large map screen to prevent map dimension manager crash");
            this.closeGui(false);
        }
        this.dimension = dim;
        this.regionPanel.setScrollX(0.0);
        this.regionPanel.setScrollY(0.0);
        this.minZoom = this.determineMinZoom();
    }

    public void onClosed() {
        super.onClosed();
        int autoRelease = (Integer)FTBChunksClientConfig.AUTORELEASE_ON_MAP_CLOSE.get();
        if (autoRelease > 0 && this.dimension != null) {
            this.dimension.manager.scheduleRegionPurge(this.dimension);
        }
    }

    public int getRegionButtonSize() {
        return this.zoom * 2;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = up > 0.0 ? (this.zoom *= 2) : (this.zoom /= 2);
        this.zoom = class_3532.method_15340((int)this.zoom, (int)this.minZoom, (int)1024);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.regionPanel.regionX;
            double sy = this.regionPanel.regionZ;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(sx, sy);
            class_310.method_1551().field_1729.field_1783 = true;
            class_310.method_1551().field_1729.method_1610();
        }
    }

    public void addWidgets() {
        this.add((Widget)this.regionPanel);
        this.claimChunksButton = new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.claimed_chunks"), Icons.MAP, (b, m) -> new ChunkScreen().openGui());
        this.add((Widget)this.claimChunksButton);
        this.waypointManagerButton = new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.waypoints"), Icons.COMPASS, (b, m) -> new WaypointEditorScreen().openGui());
        this.add((Widget)this.waypointManagerButton);
        this.clearDeathpointsButton = new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.clear_deathpoints"), Icons.CLOSE, (b, m) -> {
            WaypointManager wpm = MapManager.inst.getDimension(this.dimension.dimension).getWaypointManager();
            if (wpm.removeIf(wp -> wp.type == WaypointType.DEATH)) {
                this.refreshWidgets();
            }
        }){

            public boolean shouldDraw() {
                return super.shouldDraw() && MapManager.inst.getDimension(LargeMapScreen.this.dimension.dimension).getWaypointManager().hasDeathpoint();
            }

            public boolean isEnabled() {
                return this.shouldDraw();
            }
        };
        this.add((Widget)this.clearDeathpointsButton);
        this.dimensionButton = new SimpleButton((Panel)this, (class_2561)new class_2585(this.dimension.dimension.method_29177().method_12832().replace('_', ' ')), Icons.GLOBE, (b, m) -> {
            try {
                ArrayList<MapDimension> list = new ArrayList<MapDimension>(this.dimension.manager.getDimensions().values());
                int i = list.indexOf(this.dimension);
                if (i != -1) {
                    this.dimension = (MapDimension)list.get(MathUtils.mod((int)(i + (m.isLeft() ? 1 : -1)), (int)list.size()));
                    this.refreshWidgets();
                    this.movedToPlayer = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.add((Widget)this.dimensionButton);
        this.settingsButton = new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.settings"), Icons.SETTINGS, (b, m) -> FTBChunksClientConfig.openSettings((class_437)new ScreenWrapper((BaseScreen)this)));
        this.add((Widget)this.settingsButton);
        if (class_310.method_1551().field_1724.method_5687(2)) {
            this.serverSettingsButton = new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.settings.server"), Icons.SETTINGS.withTint(Color4I.rgb((int)10502399)), (b, m) -> FTBChunksClientConfig.openServerSettings((class_437)new ScreenWrapper((BaseScreen)this)));
            this.add((Widget)this.serverSettingsButton);
        }
    }

    public void alignWidgets() {
        this.claimChunksButton.setPosAndSize(1, 1, 16, 16);
        this.waypointManagerButton.setPosAndSize(1, 19, 16, 16);
        this.clearDeathpointsButton.setPosAndSize(1, 37, 16, 16);
        this.dimensionButton.setPosAndSize(1, this.height - 36, 16, 16);
        this.settingsButton.setPosAndSize(1, this.height - 18, 16, 16);
        if (this.serverSettingsButton != null) {
            this.serverSettingsButton.setPosAndSize(this.width - 18, this.height - 18, 16, 16);
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft()) {
            this.prevMouseX = this.getMouseX();
            this.prevMouseY = this.getMouseY();
            return true;
        }
        if (button.isRight()) {
            class_2338 pos = new class_2338(this.regionPanel.blockX, this.regionPanel.blockY, this.regionPanel.blockZ);
            ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
            list.add(new ContextMenuItem((class_2561)new class_2588("ftbchunks.gui.add_waypoint"), Icons.ADD, () -> {
                StringConfig name = new StringConfig();
                new EditConfigFromStringScreen((ConfigFromString)name, set -> {
                    if (set) {
                        Waypoint w = new Waypoint(this.dimension, pos.method_10263(), pos.method_10264(), pos.method_10260());
                        w.name = (String)name.value;
                        w.color = Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f).rgba();
                        this.dimension.getWaypointManager().add(w);
                        this.refreshWidgets();
                    }
                    this.openGui();
                }).openGui();
            }));
            this.openContextMenu(list);
            return true;
        }
        return false;
    }

    public boolean keyPressed(Key key) {
        if (FTBChunksClient.openMapKey.method_1417(key.keyCode, key.scanCode) || key.escOrInventory()) {
            if (key.esc() && this.contextMenu != null) {
                this.closeContextMenu();
            } else {
                this.closeGui(false);
            }
            return true;
        }
        if (key.is(32)) {
            this.movedToPlayer = false;
            return true;
        }
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.is(84)) {
            new TeleportFromMapPacket(this.regionPanel.blockX, this.regionPanel.blockY + 1, this.regionPanel.blockZ, this.regionPanel.blockY == -32767, this.dimension.dimension).sendToServer();
            this.closeGui(false);
            return true;
        }
        if (key.is(71) && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)292)) {
            FTBChunksClientConfig.CHUNK_GRID.toggle();
            FTBChunksClientConfig.saveConfig();
            this.dimension.manager.updateAllRegions(false);
            return true;
        }
        if (key.is(67)) {
            new ChunkScreen().openGui();
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.needIconRefresh) {
            this.regionPanel.refreshWidgets();
            this.needIconRefresh = false;
        }
    }

    public boolean drawDefaultBackground(class_4587 matrixStack) {
        if (!this.movedToPlayer) {
            class_746 p = class_310.method_1551().field_1724;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(p.method_23317() / 512.0, p.method_23321() / 512.0);
            this.movedToPlayer = true;
        }
        this.backgroundColor.draw(matrixStack, 0, 0, this.width, this.height);
        return false;
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.regionPanel.width) {
                this.regionPanel.setScrollX(Math.max(Math.min(this.regionPanel.getScrollX() + (double)(this.prevMouseX - mx), (double)(this.scrollWidth - this.regionPanel.width)), 0.0));
            }
            if (this.scrollHeight > this.regionPanel.height) {
                this.regionPanel.setScrollY(Math.max(Math.min(this.regionPanel.getScrollY() + (double)(this.prevMouseY - my), (double)(this.scrollHeight - this.regionPanel.height)), 0.0));
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
        if (this.scrollWidth <= this.regionPanel.width) {
            this.regionPanel.setScrollX((double)(this.scrollWidth - this.regionPanel.width) / 2.0);
        }
        if (this.scrollHeight <= this.regionPanel.height) {
            this.regionPanel.setScrollY((double)(this.scrollHeight - this.regionPanel.height) / 2.0);
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        int s = this.getRegionButtonSize();
        double ox = -this.regionPanel.getScrollX() % (double)s;
        double oy = -this.regionPanel.getScrollY() % (double)s;
        for (int gx = 0; gx <= w / s + 1; ++gx) {
            buffer.method_22912((double)x + ox + (double)(gx * s), (double)y, 0.0).method_1336(r, g, b, a).method_1344();
            buffer.method_22912((double)x + ox + (double)(gx * s), (double)(y + h), 0.0).method_1336(r, g, b, a).method_1344();
        }
        for (int gy = 0; gy <= h / s + 1; ++gy) {
            buffer.method_22912((double)x, (double)y + oy + (double)(gy * s), 0.0).method_1336(r, g, b, a).method_1344();
            buffer.method_22912((double)(x + w), (double)y + oy + (double)(gy * s), 0.0).method_1336(r, g, b, a).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.enableTexture();
    }

    public void drawForeground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        MapRegion region;
        MapRegionData data;
        String coords = "X: " + this.regionPanel.blockX + ", Y: " + (Serializable)(this.regionPanel.blockY == -32767 ? "??" : Integer.valueOf(this.regionPanel.blockY)) + ", Z: " + this.regionPanel.blockZ;
        if (this.regionPanel.blockY != -32767 && (data = (region = this.dimension.getRegion(XZ.regionFromBlock((int)this.regionPanel.blockX, (int)this.regionPanel.blockZ))).getData()) != null) {
            int waterLightAndBiome = data.waterLightAndBiome[this.regionPanel.blockIndex] & 0xFFFF;
            class_5321<class_1959> biome = this.dimension.manager.getBiomeKey(waterLightAndBiome);
            class_2248 block = this.dimension.manager.getBlock(data.getBlockIndex(this.regionPanel.blockIndex));
            coords = coords + " | " + class_1074.method_4662((String)("biome." + biome.method_29177().method_12836() + "." + biome.method_29177().method_12832()), (Object[])new Object[0]) + " | " + class_1074.method_4662((String)block.method_9539(), (Object[])new Object[0]);
            if ((waterLightAndBiome & 0x8000) != 0) {
                coords = coords + " (in water)";
            }
        }
        int coordsw = theme.getStringWidth(coords) / 2;
        this.backgroundColor.withAlpha(150).draw(matrixStack, x + (w - coordsw) / 2, y + h - 6, coordsw + 4, 6);
        matrixStack.method_22903();
        matrixStack.method_22904((double)((float)x + (float)(w - coordsw) / 2.0f + 2.0f), (double)(y + h - 5), 0.0);
        matrixStack.method_22905(0.5f, 0.5f, 1.0f);
        theme.drawString(matrixStack, (Object)coords, 0, 0, 2);
        matrixStack.method_22909();
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            long memory = MapManager.inst.estimateMemoryUsage();
            String memoryUsage = "Estimated Memory Usage: " + StringUtils.formatDouble00((double)((double)memory / 1024.0 / 1024.0)) + " MB";
            int memoryUsagew = theme.getStringWidth(memoryUsage) / 2;
            this.backgroundColor.withAlpha(150).draw(matrixStack, x + (w - memoryUsagew) - 2, y, memoryUsagew + 4, 6);
            matrixStack.method_22903();
            matrixStack.method_22904((double)((float)(x + (w - memoryUsagew)) - 1.0f), (double)(y + 1), 0.0);
            matrixStack.method_22905(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)memoryUsage, 0, 0, 2);
            matrixStack.method_22909();
        }
        if (this.zoom == this.minZoom && this.zoom > 1) {
            class_2588 zoomWarn = new class_2588("ftbchunks.zoom_warning");
            matrixStack.method_22903();
            matrixStack.method_22904((double)((float)x + (float)w / 2.0f), (double)(y + 1), 0.0);
            matrixStack.method_22905(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)zoomWarn, 0.0f, 0.0f, Color4I.rgb((int)0xF0C000), 4);
            matrixStack.method_22909();
        }
    }

    public static void refreshIconsIfOpen() {
        ScreenWrapper sw;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ScreenWrapper && (class_4372 = (sw = (ScreenWrapper)class_4372).getGui()) instanceof LargeMapScreen) {
            LargeMapScreen lms = (LargeMapScreen)class_4372;
            lms.needIconRefresh = true;
        }
    }

    private int determineMinZoom() {
        if (!((Boolean)FTBChunksClientConfig.MAX_ZOOM_CONSTRAINT.get()).booleanValue()) {
            return 1;
        }
        long potentialUsage = (long)this.dimension.getLoadedRegions().size() * 0x400000L;
        long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long freeMem = Runtime.getRuntime().maxMemory() - allocatedMemory;
        long ratio = freeMem / Math.max(1L, potentialUsage);
        FTBChunks.LOGGER.debug("large map: free mem = {}, potential usage = {}, ratio = {}", (Object)freeMem, (Object)potentialUsage, (Object)ratio);
        if (ratio < 8L) {
            return 64;
        }
        if (ratio < 16L) {
            return 32;
        }
        if (ratio < 32L) {
            return 16;
        }
        if (ratio < 64L) {
            return 8;
        }
        return 1;
    }
}

