/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.map.BiomeBlendMode;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftbchunks.net.ServerConfigRequestPacket;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import net.minecraft.class_310;
import net.minecraft.class_437;

public interface FTBChunksClientConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbchunks-client");
    public static final DoubleValue NOISE = (DoubleValue)CONFIG.getDouble("noise", 0.05, 0.0, 0.5).fader().comment(new String[]{"Noise added to map to make it look less plastic"});
    public static final DoubleValue SHADOWS = (DoubleValue)CONFIG.getDouble("shadows", 0.1, 0.0, 0.3).fader().comment(new String[]{"Shadow intensity"});
    public static final BooleanValue CHUNK_GRID = (BooleanValue)CONFIG.getBoolean("chunk_grid", false).comment(new String[]{"Chunk grid overlay in large map"});
    public static final BooleanValue REDUCED_COLOR_PALETTE = (BooleanValue)CONFIG.getBoolean("reduced_color_palette", false).comment(new String[]{"Reduces color palette to 256 colors"});
    public static final DoubleValue SATURATION = (DoubleValue)CONFIG.getDouble("saturation", 1.0, 0.0, 1.0).fader().comment(new String[]{"Color intensity"});
    public static final BooleanValue CLAIMED_CHUNKS_ON_MAP = (BooleanValue)CONFIG.getBoolean("claimed_chunks_on_map", true).comment(new String[]{"Show claimed chunks on the map"});
    public static final BooleanValue OWN_CLAIMED_CHUNKS_ON_MAP = (BooleanValue)CONFIG.getBoolean("own_claimed_chunks_on_map", true).comment(new String[]{"Show your own claimed chunks on the map"});
    public static final BooleanValue IN_WORLD_WAYPOINTS = (BooleanValue)CONFIG.getBoolean("in_world_waypoints", true).comment(new String[]{"Show waypoints in world"});
    public static final BooleanValue DEATH_WAYPOINTS = (BooleanValue)CONFIG.getBoolean("death_waypoints", true).comment(new String[]{"Enables creation of death waypoints"});
    public static final IntValue DEATH_WAYPOINT_AUTOREMOVE_DISTANCE = (IntValue)CONFIG.getInt("death_waypoint_autoremove_distance", 0, 0, Integer.MAX_VALUE).comment(new String[]{"Automatically remove death waypoints if closer than this many blocks away (distance of 0 disables removal)"});
    public static final BooleanValue ONLY_SURFACE_ENTITIES = (BooleanValue)CONFIG.getBoolean("only_surface_entities", true).comment(new String[]{"Only show entities that are on the surface"});
    public static final DoubleValue WAYPOINT_BEACON_FADE_DISTANCE = (DoubleValue)CONFIG.getDouble("waypoint_fade_distance", 12.0, 1.0, 200.0).comment(new String[]{"Distance at which waypoint beacons start to fade"});
    public static final DoubleValue WAYPOINT_DOT_FADE_DISTANCE = (DoubleValue)CONFIG.getDouble("waypoint_dot_fade_distance", 1.0, 1.0, 200.0).comment(new String[]{"Distance at which waypoint dots start to fade"});
    public static final EnumValue<MapMode> MAP_MODE = (EnumValue)CONFIG.getEnum("map_mode", MapMode.NAME_MAP).comment(new String[]{"Different ways to render map"});
    public static final IntValue WATER_HEIGHT_FACTOR = (IntValue)CONFIG.getInt("water_height_factor", 8, 0, 128).comment(new String[]{"How many blocks should height checks skip in water. 0 means flat water, ignoring terrain"});
    public static final EnumValue<BiomeBlendMode> BIOME_BLEND = (EnumValue)CONFIG.getEnum("biome_blend", BiomeBlendMode.NAME_MAP).comment(new String[]{"Biome blend"});
    public static final SNBTConfig MINIMAP = CONFIG.getGroup("minimap");
    public static final BooleanValue MINIMAP_ENABLED = (BooleanValue)MINIMAP.getBoolean("enabled", !FTBChunksClientConfig.hasOtherMinimapMod()).comment(new String[]{"Enable minimap"});
    public static final EnumValue<MinimapPosition> MINIMAP_POSITION = (EnumValue)MINIMAP.getEnum("position", MinimapPosition.NAME_MAP).comment(new String[]{"Enables minimap to show up in corner"});
    public static final DoubleValue MINIMAP_SCALE = (DoubleValue)MINIMAP.getDouble("scale", 1.0, 0.25, 4.0).comment(new String[]{"Scale of minimap"});
    public static final DoubleValue MINIMAP_ZOOM = (DoubleValue)MINIMAP.getDouble("zoom", 1.0, 1.0, 4.0).comment(new String[]{"Zoom distance of the minimap"});
    public static final BooleanValue MINIMAP_LOCKED_NORTH = (BooleanValue)MINIMAP.getBoolean("locked_north", true).comment(new String[]{"Minimap will not rotate"});
    public static final BooleanValue MINIMAP_WAYPOINTS = (BooleanValue)MINIMAP.getBoolean("waypoints", true).comment(new String[]{"Show waypoints on minimap"});
    public static final BooleanValue MINIMAP_PLAYER_HEADS = (BooleanValue)MINIMAP.getBoolean("player_heads", true).comment(new String[]{"Show player heads on minimap"});
    public static final BooleanValue MINIMAP_ENTITIES = (BooleanValue)MINIMAP.getBoolean("entities", true).comment(new String[]{"Show entities on minimap"});
    public static final BooleanValue MINIMAP_ENTITY_HEADS = (BooleanValue)MINIMAP.getBoolean("entity_heads", true).comment(new String[]{"Show entity heads on minimap"});
    public static final BooleanValue MINIMAP_LARGE_ENTITIES = (BooleanValue)MINIMAP.getBoolean("large_entities", false).comment(new String[]{"Entities in minimap will be larger"});
    public static final BooleanValue MINIMAP_XYZ = (BooleanValue)MINIMAP.getBoolean("xyz", true).comment(new String[]{"Show XYZ under minimap"});
    public static final BooleanValue MINIMAP_BIOME = (BooleanValue)MINIMAP.getBoolean("biome", true).comment(new String[]{"Show biome under minimap"});
    public static final EnumValue<MinimapBlurMode> MINIMAP_BLUR_MODE = (EnumValue)MINIMAP.getEnum("blur_mode", MinimapBlurMode.NAME_MAP).comment(new String[]{"Blurs minimap"});
    public static final BooleanValue MINIMAP_COMPASS = (BooleanValue)MINIMAP.getBoolean("compass", true).comment(new String[]{"Adds NWSE compass inside minimap"});
    public static final IntValue MINIMAP_VISIBILITY = (IntValue)MINIMAP.getInt("visibility", 255, 0, 255).comment(new String[]{"Minimap visibility"});
    public static final BooleanValue MINIMAP_ZONE = (BooleanValue)MINIMAP.getBoolean("zone", true).comment(new String[]{"Show zone (claimed chunk or wilderness) under minimap"});
    public static final IntValue MINIMAP_OFFSET_X = (IntValue)MINIMAP.getInt("position_offset_x", 0).comment(new String[]{"Changes the maps X offset from it's origin point. When on the Left, the map will be pushed out from the left, then from the right when on the right."});
    public static final IntValue MINIMAP_OFFSET_Y = (IntValue)MINIMAP.getInt("position_offset_y", 0).comment(new String[]{"Changes the maps X offset from it's origin point. When on the Left, the map will be pushed out from the left, then from the right when on the right."});
    public static final EnumValue<MinimapPosition.MinimapOffsetConditional> MINIMAP_POSITION_OFFSET_CONDITION = (EnumValue)MINIMAP.getEnum("position_offset_condition", MinimapPosition.MinimapOffsetConditional.NAME_MAP).comment(new String[]{"Applied a conditional check to the offset. When set to anything other that None, the offset will apply only to the selected minimap position.", "When set to none and the maps offset is greater than 0, the offset will apply to all directions"});
    public static final BooleanValue SQUARE_MINIMAP = (BooleanValue)MINIMAP.getBoolean("square", false).comment(new String[]{"Draw a square minimap instead of a circular one"});
    public static final BooleanValue DEBUG_INFO = (BooleanValue)CONFIG.getBoolean("debug_info", false).comment(new String[]{"Enables debug info"});
    public static final IntValue TASK_QUEUE_TICKS = (IntValue)CONFIG.getInt("task_queue_ticks", 4, 1, 300).excluded().comment(new String[]{"Advanced option. How often queued tasks will run"});
    public static final IntValue RERENDER_QUEUE_TICKS = (IntValue)CONFIG.getInt("rerender_queue_ticks", 60, 1, 600).excluded().comment(new String[]{"Advanced option. How often map render update will be queued"});
    public static final IntValue TASK_QUEUE_MAX = (IntValue)CONFIG.getInt("task_queue_max", 100, 1, 10000).excluded().comment(new String[]{"Advanced option. Max tasks that can queue up"});
    public static final IntValue WATER_VISIBILITY = (IntValue)CONFIG.getInt("water_visibility", 220, 0, 255).excluded().comment(new String[]{"Advanced option. Water visibility"});
    public static final IntValue GRASS_DARKNESS = (IntValue)CONFIG.getInt("grass_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Grass darkness"});
    public static final IntValue FOLIAGE_DARKNESS = (IntValue)CONFIG.getInt("foliage_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Foliage darkness"});
    public static final IntValue MINIMAP_ICON_UPDATE_TIMER = (IntValue)CONFIG.getInt("minimap_icon_update_timer", 500, 0, 10000).excluded().comment(new String[]{"Advanced option. Change how often the minimap will refresh icons"});
    public static final SNBTConfig MEMORY = CONFIG.getGroup("memory");
    public static final IntValue REGION_RELEASE_TIME = (IntValue)MEMORY.getInt("region_release_time", 300, 0, Integer.MAX_VALUE).comment(new String[]{"Periodically release region data for non-recently-used regions to save memory (units of seconds, 0 disables releasing"});
    public static final IntValue AUTORELEASE_ON_MAP_CLOSE = (IntValue)MEMORY.getInt("autorelease_on_map_close", 32, 0, Integer.MAX_VALUE).comment(new String[]{"When the large map is closed, auto-release least recently accessed regions down to this number (0 disables releasing)"});
    public static final BooleanValue MAX_ZOOM_CONSTRAINT = (BooleanValue)MEMORY.getBoolean("max_zoom_constraint", true).comment(new String[]{"Constrain maximum map zoom-out based on number of explored regions and available memory"});

    public static boolean hasOtherMinimapMod() {
        return Platform.isModLoaded((String)"journeymap") || Platform.isModLoaded((String)"voxelmap") || Platform.isModLoaded((String)"antiqueatlas") || Platform.isModLoaded((String)"xaerominimap");
    }

    public static void init() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)ConfigUtil.LOCAL_DIR.resolve("ftbchunks"), (String)"ftbchunks", (String)"client-config.snbt");
    }

    public static void openSettings(class_437 screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks");
        CONFIG.createClientConfig(group);
        EditConfigScreen gui = new EditConfigScreen(group);
        group.savedCallback = b -> {
            if (b) {
                FTBChunksClientConfig.saveConfig();
            }
            if (MapManager.inst != null) {
                MapManager.inst.updateAllRegions(false);
            }
            class_310.method_1551().method_1507(screen);
        };
        gui.openGui();
    }

    public static void openServerSettings(class_437 screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks");
        FTBChunksWorldConfig.CONFIG.createClientConfig(group);
        EditConfigScreen gui = new EditConfigScreen(group);
        group.savedCallback = b -> {
            if (b) {
                SNBTCompoundTag config = new SNBTCompoundTag();
                FTBChunksWorldConfig.CONFIG.write(config);
                new ServerConfigRequestPacket(config).sendToServer();
            }
            class_310.method_1551().method_1507(screen);
        };
        gui.openGui();
    }

    public static void saveConfig() {
        CONFIG.save(Platform.getGameFolder().resolve("local/ftbchunks/client-config.snbt"));
    }
}

