/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.SendPlayerPositionPacket;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public enum LongRangePlayerTracker {
    INSTANCE;

    private long lastTick = 0L;
    private final Table<UUID, UUID, class_2338> trackingMap = HashBasedTable.create();

    public void tick(MinecraftServer server) {
        int interval = (Integer)FTBChunksWorldConfig.LONG_RANGE_TRACKER_INTERVAL.get();
        if (interval != 0 && (long)server.method_3780() - this.lastTick > (long)interval) {
            this.lastTick = server.method_3780();
            List players = server.method_3760().method_14571();
            int maxDistSq = server.method_3760().method_14568() * server.method_3760().method_14568() * 256;
            players.forEach(p1 -> p1.method_14220().method_18456().forEach(p2 -> {
                if (this.shouldTrack((class_3222)p1, (class_3222)p2, maxDistSq)) {
                    class_2338 lastPos = (class_2338)this.trackingMap.get((Object)p1.method_5667(), (Object)p2.method_5667());
                    if (lastPos == null || p2.method_24515().method_10262((class_2382)lastPos) > 16.0) {
                        new SendPlayerPositionPacket((class_3222)p2, p2.method_24515()).sendTo((class_3222)p1);
                        this.trackingMap.put((Object)p1.method_5667(), (Object)p2.method_5667(), (Object)p2.method_24515());
                    }
                } else if (this.trackingMap.contains((Object)p1.method_5667(), (Object)p2.method_5667())) {
                    new SendPlayerPositionPacket((class_3222)p2, null).sendTo((class_3222)p1);
                    this.trackingMap.remove((Object)p1.method_5667(), (Object)p2.method_5667());
                }
            }));
        }
    }

    public void stopTracking(class_3222 player) {
        if (player.method_5682() == null) {
            return;
        }
        HashMap<UUID, UUID> toRemove = new HashMap<UUID, UUID>();
        for (UUID trackingId2 : this.trackingMap.rowKeySet()) {
            if (!this.trackingMap.contains((Object)trackingId2, (Object)player.method_5667())) continue;
            toRemove.put(trackingId2, player.method_5667());
        }
        toRemove.forEach((trackingId, disconnectedId) -> {
            class_3222 trackingPlayer = player.method_5682().method_3760().method_14602(trackingId);
            if (trackingPlayer != null) {
                new SendPlayerPositionPacket(player, null).sendTo(trackingPlayer);
            }
            this.trackingMap.remove(trackingId, disconnectedId);
        });
    }

    private boolean shouldTrack(class_3222 p1, class_3222 p2, int maxDistSq) {
        if (p1 == p2 || p1.method_5858((class_1297)p2) < (double)maxDistSq) {
            return false;
        }
        FTBChunksTeamData p2Team = FTBChunksAPI.getManager().getData(p2);
        return p2Team.canUse(p1, FTBChunksTeamData.LOCATION_MODE);
    }
}

