/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util.connection;

import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.api.client.Facade;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.util.BitUtil;

public class SpacialConnectionLogic {
    protected byte connectionMap;
    protected boolean ignoreStates;
    protected StateComparator stateComparator = StateComparator.DEFAULT;

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public StateComparator getStateComparator() {
        return this.stateComparator;
    }

    public void ignoreStates(boolean ignoreStates) {
        this.ignoreStates = ignoreStates;
    }

    public void setStateComparator(StateComparator stateComparator) {
        this.stateComparator = stateComparator;
    }

    public void buildConnectionMap(@NotNull class_1920 world, @NotNull class_2338 pos) {
        this.connectionMap = 0;
        for (class_2350 direction : class_2350.values()) {
            if (!this.isConnected(world, pos, direction)) continue;
            this.setConnected(direction, true);
        }
    }

    protected void setConnected(class_2350 direction, boolean connected) {
        this.connectionMap = connected ? BitUtil.setBit(this.connectionMap, direction.ordinal()) : BitUtil.clearBit(this.connectionMap, direction.ordinal());
    }

    public boolean isConnected(class_1920 world, class_2338 pos, class_2350 direction) {
        return this.isConnected(world, pos, pos.method_10093(direction));
    }

    public boolean isConnected(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        return this.isConnected(world, pos, pos.method_10093(direction), state);
    }

    public boolean isConnected(class_1920 world, class_2338 pos, class_2338 connection) {
        class_2680 state = this.getConnectionState(world, pos, connection);
        return this.isConnected(world, pos, connection, state);
    }

    public boolean isConnected(class_1920 world, class_2338 pos, class_2338 connection, class_2680 state) {
        class_2680 connectionState = this.getConnectionState(world, connection, pos);
        return this.compare(state, connectionState);
    }

    public class_2680 getConnectionState(class_1920 world, class_2338 pos, class_2338 connection) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() instanceof Facade) {
            class_2680 facadeState = ((Facade)state.method_26204()).getFacadeState(world, pos, connection, null);
            if (facadeState != null) {
                return facadeState;
            }
            CTMClient.LOGGER.error("Received null facade blockstate from {} at {}.", (Object)state.method_26204(), (Object)pos);
        }
        return state;
    }

    protected boolean compare(class_2680 from, class_2680 to) {
        return this.stateComparator.connects(this, from, to);
    }

    public boolean connected(class_2350 direction) {
        return BitUtil.getBit(this.connectionMap, direction.ordinal());
    }

    public boolean connectedAnd(class_2350 ... directions) {
        for (class_2350 direction : directions) {
            if (this.connected(direction)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(class_2350 ... directions) {
        for (class_2350 direction : directions) {
            if (!this.connected(direction)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConnections() {
        return this.connectionMap != 0;
    }

    public int numConnections() {
        return Integer.bitCount(this.connectionMap);
    }

    public long serialize() {
        return Byte.toUnsignedLong(this.connectionMap);
    }

    public void deserialize(long data) {
        this.connectionMap = (byte)data;
    }

    public static interface StateComparator {
        public static final StateComparator DEFAULT = (logic, from, to) -> logic.ignoreStates() ? from.method_26204() == to.method_26204() : from == to;

        public boolean connects(SpacialConnectionLogic var1, class_2680 var2, class_2680 var3);
    }
}

