/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.context;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import team.chisel.ctm.client.texture.TextureMap;
import team.chisel.ctm.client.texture.context.TextureContextPosition;
import team.chisel.ctm.client.util.DirectionUtil;

public abstract class TextureContextGrid
extends TextureContextPosition {
    private final EnumMap<class_2350, Point2i> textureCoords = new EnumMap(class_2350.class);
    private final long serialized;

    public TextureContextGrid(class_2338 pos, TextureMap texture, boolean applyOffset) {
        super(pos);
        Preconditions.checkArgument((texture.getXSize() * texture.getYSize() < 1024 ? 1 : 0) != 0, (String)"V* Texture size too large for texture %s", (Object)texture.getParticle());
        if (applyOffset) {
            this.applyOffset();
        }
        long serialized = 0L;
        for (class_2350 side : class_2350.values()) {
            class_2338 modifiedPosition = this.pos.method_10081(DirectionUtil.getRelativeOffset(side, texture.getXOffset(), texture.getYOffset()));
            Point2i coords = this.calculateTextureCoord(modifiedPosition, texture.getXSize(), texture.getYSize(), side);
            this.textureCoords.put(side, coords);
            serialized |= (long)(coords.x + coords.y * texture.getXSize() << side.ordinal() * 10);
        }
        this.serialized = serialized;
    }

    public Point2i getTextureCoords(class_2350 side) {
        return this.textureCoords.get(side);
    }

    protected abstract Point2i calculateTextureCoord(class_2338 var1, int var2, int var3, class_2350 var4);

    @Override
    public long serialize() {
        return this.serialized;
    }

    public static final class Point2i {
        private final int x;
        private final int y;

        public Point2i(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point2i)) {
                return false;
            }
            Point2i other = (Point2i)o;
            if (this.getX() != other.getX()) {
                return false;
            }
            return this.getY() == other.getY();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getX();
            result = result * 59 + this.getY();
            return result;
        }

        public String toString() {
            return "TextureContextGrid.Point2i(x=" + this.getX() + ", y=" + this.getY() + ")";
        }
    }

    public static class TextureContextRandom
    extends TextureContextGrid {
        private static final Random RANDOM = new Random();

        public TextureContextRandom(class_2338 pos, TextureMap texture, boolean applyOffset) {
            super(pos, texture, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(class_2338 pos, int width, int height, class_2350 side) {
            RANDOM.setSeed(class_3532.method_15389((class_2382)pos) + (long)side.ordinal());
            RANDOM.nextBoolean();
            int tx = RANDOM.nextInt(width) + 1;
            int ty = RANDOM.nextInt(height) + 1;
            return new Point2i(tx, ty);
        }
    }

    public static class TextureContextPatterned
    extends TextureContextGrid {
        public TextureContextPatterned(class_2338 pos, TextureMap texture, boolean applyOffset) {
            super(pos, texture, applyOffset);
        }

        @Override
        protected Point2i calculateTextureCoord(class_2338 pos, int width, int height, class_2350 side) {
            int ty;
            int tx;
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            if (side.method_10166().method_10178()) {
                tx = x % width;
                ty = (side.method_10164() * z + 1) % height;
            } else if (side.method_10166() == class_2350.class_2351.field_11051) {
                tx = x % width;
                ty = -y % height;
            } else {
                tx = (z + 1) % width;
                ty = -y % height;
            }
            if (side == class_2350.field_11043 || side == class_2350.field_11034) {
                tx = (width - tx - 1) % width;
            }
            if (tx < 0) {
                tx += width;
            }
            if (ty < 0) {
                ty += height;
            }
            return new Point2i(tx, ty);
        }
    }
}

