/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.Renderable;
import team.chisel.ctm.api.client.TextureContext;
import team.chisel.ctm.api.client.TextureInfo;
import team.chisel.ctm.client.render.SubmapImpl;
import team.chisel.ctm.client.render.UnbakedQuad;
import team.chisel.ctm.client.texture.AbstractTexture;
import team.chisel.ctm.client.texture.context.TextureContextGrid;
import team.chisel.ctm.client.texture.type.TextureTypeMap;

public class TextureMap
extends AbstractTexture<TextureTypeMap> {
    private final int xSize;
    private final int ySize;
    private final int xOffset;
    private final int yOffset;
    private final MapType mapType;

    public TextureMap(TextureTypeMap type, TextureInfo info) {
        super(type, info);
        this.mapType = type.getType();
        if (info.getExtraInfo().isPresent()) {
            JsonObject jsonObject = info.getExtraInfo().get();
            if (jsonObject.has("width") && jsonObject.has("height")) {
                Preconditions.checkArgument((jsonObject.get("width").isJsonPrimitive() && jsonObject.get("width").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"width must be a number!");
                Preconditions.checkArgument((jsonObject.get("height").isJsonPrimitive() && jsonObject.get("height").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"height must be a number!");
                this.xSize = jsonObject.get("width").getAsInt();
                this.ySize = jsonObject.get("height").getAsInt();
            } else if (jsonObject.has("size")) {
                Preconditions.checkArgument((jsonObject.get("size").isJsonPrimitive() && jsonObject.get("size").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"size must be a number!");
                this.xSize = jsonObject.get("size").getAsInt();
                this.ySize = jsonObject.get("size").getAsInt();
            } else {
                this.ySize = 2;
                this.xSize = 2;
            }
            if (jsonObject.has("x_offset")) {
                Preconditions.checkArgument((jsonObject.get("x_offset").isJsonPrimitive() && jsonObject.get("x_offset").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"x_offset must be a number!");
                this.xOffset = jsonObject.get("x_offset").getAsInt();
            } else {
                this.xOffset = 0;
            }
            if (jsonObject.has("y_offset")) {
                Preconditions.checkArgument((jsonObject.get("y_offset").isJsonPrimitive() && jsonObject.get("y_offset").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"y_offset must be a number!");
                this.yOffset = jsonObject.get("y_offset").getAsInt();
            } else {
                this.yOffset = 0;
            }
        } else {
            this.yOffset = 0;
            this.xOffset = 0;
            this.ySize = 2;
            this.xSize = 2;
        }
        Preconditions.checkArgument((this.xSize > 0 && this.ySize > 0 ? 1 : 0) != 0, (Object)"Cannot have a dimension of 0!");
    }

    @Override
    public Renderable transformQuad(class_777 bakedQuad, class_2350 cullFace, TextureContext context) {
        return this.mapType.transformQuad(this, bakedQuad, cullFace, context);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public static interface MapType {
        public Renderable transformQuad(TextureMap var1, class_777 var2, class_2350 var3, @Nullable TextureContext var4);

        @NotNull
        public TextureContext getContext(@NotNull class_2338 var1, @NotNull TextureMap var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MapTypeImpl implements MapType
    {
        RANDOM{

            @Override
            public Renderable transformQuad(TextureMap texture, class_777 bakedQuad, class_2350 cullFace, @Nullable TextureContext context) {
                UnbakedQuad quad = texture.unbake(bakedQuad, cullFace);
                TextureContextGrid.Point2i textureCoords = context instanceof TextureContextGrid ? ((TextureContextGrid)context).getTextureCoords(quad.lightFace) : new TextureContextGrid.Point2i(1, 1);
                float intervalX = 16.0f / (float)texture.getXSize();
                float intervalY = 16.0f / (float)texture.getYSize();
                float maxX = intervalX * (float)textureCoords.getX();
                float maxY = intervalY * (float)textureCoords.getY();
                SubmapImpl submap = new SubmapImpl(intervalX, intervalY, maxX - intervalX, maxY - intervalY);
                quad.setUVBounds(texture.sprites[0]);
                quad.applySubmap(submap);
                return quad;
            }

            @Override
            public TextureContext getContext(@NotNull class_2338 pos, @NotNull TextureMap texture) {
                return new TextureContextGrid.TextureContextRandom(pos, texture, true);
            }
        }
        ,
        PATTERNED{

            @Override
            public Renderable transformQuad(TextureMap texture, class_777 bakedQuad, class_2350 cullFace, @Nullable TextureContext context) {
                UnbakedQuad quad = texture.unbake(bakedQuad, cullFace);
                TextureContextGrid.Point2i textureCoords = context instanceof TextureContextGrid ? ((TextureContextGrid)context).getTextureCoords(quad.lightFace) : new TextureContextGrid.Point2i(0, 0);
                float intervalX = 16.0f / (float)texture.getXSize();
                float intervalY = 16.0f / (float)texture.getYSize();
                float minX = intervalX * (float)textureCoords.getX();
                float minY = intervalY * (float)textureCoords.getY();
                SubmapImpl submap = new SubmapImpl(intervalX, intervalY, minX, minY);
                quad.setUVBounds(texture.sprites[0]);
                quad.applySubmap(submap);
                return quad;
            }

            @Override
            public TextureContext getContext(@NotNull class_2338 pos, @NotNull TextureMap texture) {
                return new TextureContextGrid.TextureContextPatterned(pos, texture, true);
            }
        };

    }
}

