/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture;

import net.minecraft.class_2350;
import net.minecraft.class_777;
import team.chisel.ctm.api.client.Renderable;
import team.chisel.ctm.api.client.TextureContext;
import team.chisel.ctm.api.client.TextureInfo;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.render.RenderableArray;
import team.chisel.ctm.client.render.Submap;
import team.chisel.ctm.client.render.SubmapImpl;
import team.chisel.ctm.client.render.UnbakedQuad;
import team.chisel.ctm.client.texture.AbstractConnectingTexture;
import team.chisel.ctm.client.texture.context.TextureContextConnecting;
import team.chisel.ctm.client.texture.type.TextureTypeCTM;
import team.chisel.ctm.client.util.connection.ConnectionDirection;
import team.chisel.ctm.client.util.connection.ConnectionLogic;

public class TextureCTM
extends AbstractConnectingTexture<TextureTypeCTM> {
    protected static final ConnectionDirection[][] DIRECTION_MAP = new ConnectionDirection[][]{{ConnectionDirection.TOP, ConnectionDirection.LEFT, ConnectionDirection.TOP_LEFT}, {ConnectionDirection.BOTTOM, ConnectionDirection.LEFT, ConnectionDirection.BOTTOM_LEFT}, {ConnectionDirection.BOTTOM, ConnectionDirection.RIGHT, ConnectionDirection.BOTTOM_RIGHT}, {ConnectionDirection.TOP, ConnectionDirection.RIGHT, ConnectionDirection.TOP_RIGHT}};

    public TextureCTM(TextureTypeCTM type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public Renderable transformQuad(class_777 bakedQuad, class_2350 cullFace, TextureContext context) {
        UnbakedQuad quad = this.unbake(bakedQuad, cullFace);
        if (CTMClient.getConfigManager().getConfig().disableCTM || !(context instanceof TextureContextConnecting)) {
            quad.setUVBounds(this.sprites[0]);
            return quad;
        }
        ConnectionLogic logic = ((TextureContextConnecting)context).getLogic(quad.lightFace);
        Renderable[] quads = quad.toQuadrants();
        for (int i = 0; i < quads.length; ++i) {
            if (quads[i] == null) continue;
            int id = this.getSubmapId(logic, i);
            if (id != -1) {
                ((UnbakedQuad)quads[i]).setUVBounds(this.sprites[1]);
                ((UnbakedQuad)quads[i]).applySubmap(TextureCTM.getX2Submap(id, quad.areUVsRotatedOnce()));
                continue;
            }
            ((UnbakedQuad)quads[i]).setUVBounds(this.sprites[0]);
        }
        return new RenderableArray(quads);
    }

    protected int getSubmapId(ConnectionLogic logic, int quadrant) {
        ConnectionDirection[] directions = DIRECTION_MAP[quadrant];
        boolean connected1 = logic.connected(directions[0]);
        boolean connected2 = logic.connected(directions[1]);
        if (connected1 && connected2) {
            if (logic.connected(directions[2])) {
                return 0;
            }
            return 3;
        }
        if (connected1) {
            return 1;
        }
        if (connected2) {
            return 2;
        }
        return -1;
    }

    public static Submap getX2Submap(int id, boolean rotate) {
        if (rotate) {
            if (id == 1) {
                id = 2;
            } else if (id == 2) {
                id = 1;
            }
        }
        return SubmapImpl.getX2Submap(id);
    }
}

