/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture;

import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.TextureInfo;
import team.chisel.ctm.api.client.TextureType;
import team.chisel.ctm.client.render.UnbakedQuad;
import team.chisel.ctm.client.resource.BlockStatePredicateParser;
import team.chisel.ctm.client.texture.AbstractTexture;
import team.chisel.ctm.client.util.ParseUtil;
import team.chisel.ctm.client.util.connection.ConnectionLogic;

public abstract class AbstractConnectingTexture<T extends TextureType>
extends AbstractTexture<T> {
    protected Optional<Boolean> connectInside;
    protected boolean ignoreStates;
    protected boolean untransform;
    @Nullable
    private final BiPredicate<class_2350, class_2680> connectionChecks;
    private final ConnectionLogic.StateComparator comparator;

    public AbstractConnectingTexture(T type, TextureInfo info) {
        super(type, info);
        this.connectInside = info.getExtraInfo().flatMap(obj -> ParseUtil.getOptionalBoolean(obj, "connect_inside"));
        this.ignoreStates = info.getExtraInfo().map(obj -> class_3518.method_15258((JsonObject)obj, (String)"ignore_states", (boolean)false)).orElse(false);
        this.untransform = info.getExtraInfo().map(obj -> class_3518.method_15258((JsonObject)obj, (String)"untransform", (boolean)false)).orElse(false);
        this.connectionChecks = info.getExtraInfo().map(obj -> BlockStatePredicateParser.INSTANCE.parse(obj.get("connect_to"))).orElse(null);
        this.comparator = this.connectionChecks == null ? ConnectionLogic.StateComparator.DEFAULT : (logic, from, to, side) -> this.connectionChecks.test(side, to);
    }

    @Override
    protected UnbakedQuad unbake(class_777 bakedQuad, class_2350 cullFace) {
        UnbakedQuad quad = super.unbake(bakedQuad, cullFace);
        if (this.untransform) {
            quad.untransformUVs();
        }
        return quad;
    }

    public Optional<Boolean> connectInside() {
        return this.connectInside;
    }

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public void configureLogic(@NotNull ConnectionLogic logic) {
        logic.disableObscuredFaceCheck = this.connectInside();
        logic.ignoreStates(this.ignoreStates());
        logic.setStateComparator(this.comparator);
    }
}

