/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.resource;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.class_793;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.resource.ModelParser;

public class ModelParserV1
implements ModelParser {
    private static final Gson GSON = new Gson();
    private static final Type OVERRIDE_TYPE = new TypeToken<Map<String, JsonElement>>(){}.getType();

    @Override
    @NotNull
    public Int2ObjectMap<JsonElement> parse(class_793 jsonModel, JsonObject jsonObject, Type type, JsonDeserializationContext context) {
        try {
            Map unparsedOverrides = (Map)GSON.fromJson((JsonElement)jsonObject.getAsJsonObject("ctm_overrides"), OVERRIDE_TYPE);
            if (unparsedOverrides != null && unparsedOverrides.size() > 0) {
                Int2ObjectArrayMap overrides = new Int2ObjectArrayMap(unparsedOverrides.size());
                for (Map.Entry entry : unparsedOverrides.entrySet()) {
                    try {
                        int tintIndex = Integer.parseInt((String)entry.getKey());
                        overrides.put(tintIndex, (Object)((JsonElement)entry.getValue()));
                    }
                    catch (NumberFormatException e) {
                        CTMClient.LOGGER.error("Error parsing model {}: \"{}\" is not a valid tintindex.", (Object)jsonObject, entry.getKey());
                    }
                }
                return overrides;
            }
        }
        catch (Exception e) {
            CTMClient.LOGGER.error("Error parsing model " + jsonObject + ".", (Throwable)e);
        }
        return null;
    }
}

