/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.render;

import java.util.Objects;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_777;
import team.chisel.ctm.api.client.Renderable;
import team.chisel.ctm.client.render.Submap;
import team.chisel.ctm.client.util.MathUtil;
import team.chisel.ctm.client.util.RenderUtil;

public class UnbakedQuad
implements Renderable,
Cloneable {
    public static final float[] FULL_BOUNDS = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static final float CENTER = 0.5f;
    public static final float[] CENTER_POINT = new float[]{0.5f, 0.5f};
    public Vertex[] vertexes;
    public class_2350 cullFace;
    public class_2350 lightFace;
    public int colorIndex;
    public class_1058 sprite;
    public RenderMaterial material;

    public UnbakedQuad() {
    }

    public UnbakedQuad(class_777 bakedQuad) {
        this.lightFace = bakedQuad.method_3358();
        this.colorIndex = bakedQuad.method_3359();
        this.sprite = bakedQuad.method_35788();
        int[] data = bakedQuad.method_3357();
        this.vertexes = new Vertex[4];
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex;
            int offset = vertexId * 8;
            this.vertexes[vertexId] = vertex = new Vertex();
            vertex.x = Float.intBitsToFloat(data[offset]);
            vertex.y = Float.intBitsToFloat(data[offset + 1]);
            vertex.z = Float.intBitsToFloat(data[offset + 2]);
            vertex.decodeColor(data[offset + 3]);
            vertex.u = MathUtil.getLerpProgress(Float.intBitsToFloat(data[offset + 4]), this.sprite.method_4594(), this.sprite.method_4577());
            vertex.v = MathUtil.getLerpProgress(Float.intBitsToFloat(data[offset + 5]), this.sprite.method_4593(), this.sprite.method_4575());
            vertex.decodeLight(data[offset + 6]);
        }
    }

    public UnbakedQuad(QuadView quadView, class_1058 sprite) {
        this.cullFace = quadView.cullFace();
        this.lightFace = quadView.lightFace();
        this.colorIndex = quadView.colorIndex();
        this.sprite = sprite;
        this.material = quadView.material();
        this.vertexes = new Vertex[4];
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex;
            this.vertexes[vertexId] = vertex = new Vertex();
            vertex.x = quadView.x(vertexId);
            vertex.y = quadView.y(vertexId);
            vertex.z = quadView.z(vertexId);
            vertex.decodeColor(quadView.spriteColor(vertexId, 0));
            vertex.u = MathUtil.getLerpProgress(quadView.spriteU(vertexId, 0), sprite.method_4594(), sprite.method_4577());
            vertex.v = MathUtil.getLerpProgress(quadView.spriteV(vertexId, 0), sprite.method_4593(), sprite.method_4575());
            vertex.decodeLight(quadView.lightmap(vertexId));
        }
    }

    @Override
    public void render(QuadEmitter emitter) {
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            emitter.pos(vertexId, vertex.x, vertex.y, vertex.z);
            emitter.spriteColor(vertexId, 0, RenderUtil.getColor(vertex.alpha, vertex.red, vertex.green, vertex.blue));
            emitter.sprite(vertexId, 0, class_3532.method_16439((float)vertex.u, (float)this.sprite.method_4594(), (float)this.sprite.method_4577()), class_3532.method_16439((float)vertex.v, (float)this.sprite.method_4593(), (float)this.sprite.method_4575()));
            emitter.lightmap(vertexId, RenderUtil.getLight(vertex.skyLight, vertex.blockLight));
        }
        emitter.cullFace(this.cullFace);
        emitter.colorIndex(this.colorIndex);
        emitter.material(this.material);
        emitter.emit();
    }

    public void setColor(int alpha, int red, int green, int blue) {
        alpha &= 0xFF;
        red &= 0xFF;
        green &= 0xFF;
        blue &= 0xFF;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            vertex.alpha = alpha;
            vertex.red = red;
            vertex.green = green;
            vertex.blue = blue;
        }
    }

    public void setLight(int skyLight, int blockLight) {
        skyLight &= 0xF;
        blockLight &= 0xF;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            vertex.skyLight = skyLight;
            vertex.blockLight = blockLight;
        }
    }

    public void setUVBounds(float[] bounds, float[] newBounds) {
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            vertex.u = class_3532.method_16439((float)class_3532.method_37960((float)vertex.u, (float)bounds[0], (float)bounds[2]), (float)newBounds[0], (float)newBounds[2]);
            vertex.v = class_3532.method_16439((float)class_3532.method_37960((float)vertex.v, (float)bounds[1], (float)bounds[3]), (float)newBounds[1], (float)newBounds[3]);
        }
    }

    public void setUVBounds(float[] newBounds) {
        this.setUVBounds(FULL_BOUNDS, newBounds);
    }

    public void setUVBounds(class_1058 sprite) {
        this.sprite = sprite;
    }

    public void applySubmap(float[] bounds, Submap submap) {
        Submap normalizedSubmap = submap.normalize();
        float[] newBounds = (float[])bounds.clone();
        float width = newBounds[2] - newBounds[0];
        float height = newBounds[3] - newBounds[1];
        newBounds[0] = newBounds[0] + normalizedSubmap.getXOffset() * width;
        newBounds[1] = newBounds[1] + normalizedSubmap.getYOffset() * height;
        newBounds[2] = newBounds[2] - (1.0f - (normalizedSubmap.getXOffset() + normalizedSubmap.getWidth())) * width;
        newBounds[3] = newBounds[3] - (1.0f - (normalizedSubmap.getYOffset() + normalizedSubmap.getHeight())) * height;
        this.setUVBounds(bounds, newBounds);
    }

    public void applySubmap(Submap submap) {
        this.applySubmap(FULL_BOUNDS, submap);
    }

    public void rotateUVs(float[] center, int rotation) {
        if ((rotation %= 4) == 0) {
            return;
        }
        if (rotation < 0) {
            rotation += 4;
        }
        boolean check1 = rotation / 2 == 1;
        boolean check2 = rotation % 2 == 1;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            float u = vertex.u - center[0];
            float v = vertex.v - center[1];
            if (check1) {
                u *= -1.0f;
                v *= -1.0f;
            }
            if (check2) {
                float temp = u;
                u = -v;
                v = temp;
            }
            vertex.u = u + center[0];
            vertex.v = v + center[1];
        }
    }

    public void rotateUVs(int rotation) {
        this.rotateUVs(CENTER_POINT, rotation);
    }

    public void reflectUVs(float line, Reflection reflection) {
        block3: {
            block2: {
                if (reflection != Reflection.HORIZONTAL) break block2;
                for (int vertexId = 0; vertexId < 4; ++vertexId) {
                    this.vertexes[vertexId].u = -(this.vertexes[vertexId].u - line) + line;
                }
                break block3;
            }
            if (reflection != Reflection.VERTICAL) break block3;
            for (int vertexId = 0; vertexId < 4; ++vertexId) {
                this.vertexes[vertexId].v = -(this.vertexes[vertexId].v - line) + line;
            }
        }
    }

    public void reflectUVs(Reflection reflection) {
        this.reflectUVs(0.5f, reflection);
    }

    public void untransformUVs(float[] center) {
        Winding winding = this.getUVWinding();
        int rotation = this.getUVRotation();
        if (winding == Winding.CLOCKWISE) {
            if (rotation == 1) {
                this.reflectUVs(center[1], Reflection.VERTICAL);
            } else if (rotation == 3) {
                this.reflectUVs(center[0], Reflection.HORIZONTAL);
            } else {
                this.reflectUVs(center[0], Reflection.HORIZONTAL);
                this.rotateUVs(center, rotation - 1);
            }
        } else {
            this.rotateUVs(center, -rotation);
        }
    }

    public void untransformUVs() {
        this.untransformUVs(CENTER_POINT);
    }

    public int getUVRotation() {
        int minVertex = -1;
        float minDistance = 2.0f;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            float distance = vertex.u * vertex.u + vertex.v * vertex.v;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minVertex = vertexId;
        }
        return minVertex;
    }

    public Winding getUVWinding() {
        float val = (this.vertexes[3].u - this.vertexes[0].u) * (this.vertexes[1].v - this.vertexes[0].v) - (this.vertexes[3].v - this.vertexes[0].v) * (this.vertexes[1].u - this.vertexes[0].u);
        if (val > 0.0f) {
            return Winding.COUNTERCLOCKWISE;
        }
        if (val < 0.0f) {
            return Winding.CLOCKWISE;
        }
        return Winding.UNDEFINED;
    }

    public boolean areUVsRotatedOnce() {
        return this.getUVRotation() % 2 == (this.getUVWinding() == Winding.COUNTERCLOCKWISE ? 1 : 0);
    }

    public float[] getSmallestUVBounds() {
        float minU = 1.0f;
        float minV = 1.0f;
        float maxU = 0.0f;
        float maxV = 0.0f;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            Vertex vertex = this.vertexes[vertexId];
            if (vertex.u < minU) {
                minU = vertex.u;
            } else if (vertex.u > maxU) {
                maxU = vertex.u;
            }
            if (vertex.v < minV) {
                minV = vertex.v;
                continue;
            }
            if (!(vertex.v > maxV)) continue;
            maxV = vertex.v;
        }
        return new float[]{minU, minV, maxU, maxV};
    }

    public UnbakedQuad[] divide(float delta, boolean shift) {
        UnbakedQuad quad1 = this.cloneProperties();
        UnbakedQuad quad2 = this.cloneProperties();
        UnbakedQuad[] quads = new UnbakedQuad[]{quad1, quad2};
        if (!shift) {
            Vertex vertex1 = Vertex.lerp(this.vertexes[0], this.vertexes[1], delta);
            Vertex vertex2 = Vertex.lerp(this.vertexes[3], this.vertexes[2], delta);
            quad1.vertexes = new Vertex[]{this.vertexes[0].clone(), vertex1, vertex2, this.vertexes[3].clone()};
            quad2.vertexes = new Vertex[]{vertex1.clone(), this.vertexes[1].clone(), this.vertexes[2].clone(), vertex2.clone()};
        } else {
            Vertex vertex1 = Vertex.lerp(this.vertexes[0], this.vertexes[3], delta);
            Vertex vertex2 = Vertex.lerp(this.vertexes[1], this.vertexes[2], delta);
            quad1.vertexes = new Vertex[]{this.vertexes[0].clone(), this.vertexes[1].clone(), vertex2, vertex1};
            quad2.vertexes = new Vertex[]{vertex1.clone(), vertex2.clone(), this.vertexes[2].clone(), this.vertexes[3].clone()};
        }
        return quads;
    }

    public UnbakedQuad[] toQuadrants() {
        UnbakedQuad[] quadrants = new UnbakedQuad[4];
        UnbakedQuad[] quads = this.divide(0.5f, true);
        UnbakedQuad quad1 = quads[0];
        UnbakedQuad quad2 = quads[1];
        quads = quad1.divide(0.5f, false);
        quadrants[0] = quads[0];
        quadrants[1] = quads[1];
        quads = quad2.divide(0.5f, false);
        quadrants[2] = quads[1];
        quadrants[3] = quads[0];
        return quadrants;
    }

    public UnbakedQuad cloneProperties() {
        UnbakedQuad quad = new UnbakedQuad();
        quad.cullFace = this.cullFace;
        quad.lightFace = this.lightFace;
        quad.colorIndex = this.colorIndex;
        quad.sprite = this.sprite;
        quad.material = this.material;
        return quad;
    }

    public UnbakedQuad clone() {
        UnbakedQuad quad = this.cloneProperties();
        this.vertexes = new Vertex[4];
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            quad.vertexes[vertexId] = this.vertexes[vertexId].clone();
        }
        return quad;
    }

    public static class Vertex
    implements Cloneable {
        public float x;
        public float y;
        public float z;
        public int alpha;
        public int red;
        public int green;
        public int blue;
        public float u;
        public float v;
        public int skyLight;
        public int blockLight;

        public void decodeColor(int color) {
            this.alpha = color >> 24 & 0xFF;
            this.red = color >> 16 & 0xFF;
            this.green = color >> 8 & 0xFF;
            this.blue = color & 0xFF;
        }

        public void decodeLight(int light) {
            this.skyLight = light >> 20 & 0xF;
            this.blockLight = light >> 4 & 0xF;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), this.alpha, this.red, this.green, this.blue, Float.valueOf(this.u), Float.valueOf(this.v), this.skyLight, this.blockLight);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return Float.floatToIntBits(this.x) == Float.floatToIntBits(other.x) && Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y) && Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z) && this.alpha == other.alpha && this.red == other.red && this.green == other.green && this.blue == other.blue && Float.floatToIntBits(this.u) == Float.floatToIntBits(other.u) && Float.floatToIntBits(this.v) == Float.floatToIntBits(other.v) && this.skyLight == other.skyLight && this.blockLight == other.blockLight;
        }

        public Vertex clone() {
            Vertex newVertex = new Vertex();
            newVertex.x = this.x;
            newVertex.y = this.y;
            newVertex.z = this.z;
            newVertex.alpha = this.alpha;
            newVertex.red = this.red;
            newVertex.green = this.green;
            newVertex.blue = this.blue;
            newVertex.u = this.u;
            newVertex.v = this.v;
            newVertex.skyLight = this.skyLight;
            newVertex.blockLight = this.blockLight;
            return newVertex;
        }

        public static Vertex lerp(Vertex min, Vertex max, float delta) {
            Vertex newVertex = new Vertex();
            newVertex.x = class_3532.method_16439((float)delta, (float)min.x, (float)max.x);
            newVertex.y = class_3532.method_16439((float)delta, (float)min.y, (float)max.y);
            newVertex.z = class_3532.method_16439((float)delta, (float)min.z, (float)max.z);
            newVertex.alpha = MathUtil.lerp(delta, min.alpha, max.alpha);
            newVertex.red = MathUtil.lerp(delta, min.red, max.red);
            newVertex.green = MathUtil.lerp(delta, min.green, max.green);
            newVertex.blue = MathUtil.lerp(delta, min.blue, max.blue);
            newVertex.u = class_3532.method_16439((float)delta, (float)min.u, (float)max.u);
            newVertex.v = class_3532.method_16439((float)delta, (float)min.v, (float)max.v);
            newVertex.skyLight = MathUtil.lerp(delta, min.skyLight, max.skyLight);
            newVertex.blockLight = MathUtil.lerp(delta, min.blockLight, max.blockLight);
            return newVertex;
        }
    }

    public static enum Reflection {
        HORIZONTAL,
        VERTICAL,
        NONE;


        public Reflection opposite() {
            if (this == NONE) {
                return this;
            }
            return this == HORIZONTAL ? VERTICAL : HORIZONTAL;
        }
    }

    public static enum Winding {
        COUNTERCLOCKWISE,
        CLOCKWISE,
        UNDEFINED;


        public Winding reverse() {
            if (this == UNDEFINED) {
                return this;
            }
            return this == CLOCKWISE ? COUNTERCLOCKWISE : CLOCKWISE;
        }
    }
}

