/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.handler;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.event.AtlasStitchCallback;
import team.chisel.ctm.client.resource.CTMMetadataSection;
import team.chisel.ctm.client.util.ResourceUtil;

public class AtlasStitchCallbackHandler
implements AtlasStitchCallback {
    @Override
    public void onAtlasStitch(class_1059 atlas, Set<class_2960> sprites) {
        if (!atlas.method_24106().equals((Object)class_1059.field_5275)) {
            return;
        }
        HashSet<class_2960> newSprites = new HashSet<class_2960>();
        for (class_2960 identifier : sprites) {
            this.addSprites(identifier, newSprites);
        }
        sprites.addAll(newSprites);
    }

    private void addSprites(class_2960 identifier, Set<class_2960> newSprites) {
        CTMMetadataSection metadata = ResourceUtil.getMetadataSafe(ResourceUtil.toTextureIdentifier(identifier));
        if (metadata != null) {
            if (metadata.getProxy() != null) {
                class_2960 proxy = metadata.getProxy();
                newSprites.add(proxy);
                CTMMetadataSection proxyMetadata = ResourceUtil.getMetadataSafe(ResourceUtil.toTextureIdentifier(proxy));
                if (proxyMetadata != null) {
                    this.addSprites(proxy, proxyMetadata, newSprites);
                }
            } else {
                this.addSprites(identifier, metadata, newSprites);
            }
        }
    }

    private void addSprites(class_2960 identifier, CTMMetadataSection metadata, Set<class_2960> newSprites) {
        int provided;
        int required = metadata.getType().requiredTextures();
        if (required > (provided = metadata.getAdditionalTextures().length + 1)) {
            CTMClient.LOGGER.error("Too few textures provided for sprite {}: TextureType {} requires {} textures, but {} were provided.", (Object)identifier, (Object)metadata.getType(), (Object)required, (Object)provided);
        } else if (required < provided) {
            CTMClient.LOGGER.warn("Too many textures provided for sprite {}: TextureType {} requires {} textures, but {} were provided.", (Object)identifier, (Object)metadata.getType(), (Object)required, (Object)provided);
        }
        for (class_2960 id : metadata.getAdditionalTextures()) {
            newSprites.add(id);
        }
    }
}

