/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.model.CTMBakedModel;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private File file;
    private Config config;

    public ConfigManager(File file) {
        this.file = file;
    }

    public Config getConfig() {
        return this.config;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                CTMClient.LOGGER.error("Error loading config.", (Throwable)e);
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.save();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(GSON.toJson((Object)this.config));
        }
        catch (IOException e) {
            CTMClient.LOGGER.error("Error saving config.", (Throwable)e);
        }
    }

    public void onConfigChange() {
        CTMBakedModel.invalidateCaches();
        class_310.method_1551().field_1769.method_3279();
        this.save();
    }

    public static class Config {
        public boolean disableCTM = false;
        public boolean connectInsideCTM = false;
    }
}

