/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.IListTag;
import net.creeperhost.levelio.lib.nbt.ITag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCNBTImpl
implements NBTHandler {
    private static InputStream handleCompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        if (signature == 35615) {
            return new GZIPInputStream(pbis);
        }
        return pbis;
    }

    @Override
    @Nullable
    public ICompoundTag read(Path path) throws IOException {
        try (InputStream is = MCNBTImpl.handleCompression(Files.newInputStream(path, new OpenOption[0]));){
            ICompoundTag iCompoundTag = this.read(is);
            return iCompoundTag;
        }
    }

    @Override
    @Nullable
    public ICompoundTag read(InputStream is) throws IOException {
        return new CompoundWrapper(class_2507.method_10627((DataInput)new DataInputStream(is)));
    }

    @Override
    @Nullable
    public ICompoundTag fromSNBT(String snbt) throws IOException {
        try {
            return new CompoundWrapper(class_2512.method_32260((String)snbt));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    @Override
    public void write(ICompoundTag tag, Path path) throws IOException {
        class_2507.method_10630((class_2487)((class_2487)tag.unwrap()), (File)path.toFile());
    }

    @Override
    public ICompoundTag emptyCompound() {
        return new CompoundWrapper(new class_2487());
    }

    public static class CompoundWrapper
    implements ICompoundTag {
        private final class_2487 tag;

        public CompoundWrapper(class_2487 tag) {
            this.tag = tag;
        }

        @Override
        public void put(String name, ITag value) {
            this.tag.method_10566(name, (class_2520)value.unwrap());
        }

        @Override
        public void putByte(String name, byte value) {
            this.tag.method_10567(name, value);
        }

        @Override
        public void putShort(String name, short value) {
            this.tag.method_10575(name, value);
        }

        @Override
        public void putInt(String name, int value) {
            this.tag.method_10569(name, value);
        }

        @Override
        public void putLong(String name, long value) {
            this.tag.method_10544(name, value);
        }

        @Override
        public void putUUID(String name, UUID value) {
            this.tag.method_10539(name, CompoundWrapper.uuidToIntArray(value));
        }

        private static int[] uuidToIntArray(UUID uuid) {
            long most = uuid.getMostSignificantBits();
            long least = uuid.getLeastSignificantBits();
            return CompoundWrapper.leastMostToIntArray(most, least);
        }

        private static int[] leastMostToIntArray(long most, long least) {
            return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
        }

        private static UUID uuidFromIntArray(int[] uuidInts) {
            return new UUID((long)uuidInts[0] << 32 | (long)uuidInts[1] & 0xFFFFFFFFL, (long)uuidInts[2] << 32 | (long)uuidInts[3] & 0xFFFFFFFFL);
        }

        @Override
        public UUID getUUID(String name) {
            int[] ints = this.tag.method_10561(name);
            if (ints.length == 4) {
                return CompoundWrapper.uuidFromIntArray(ints);
            }
            throw new IllegalArgumentException("Invalid UUID tag, Expected int array of length 4, found " + ints);
        }

        @Override
        public boolean hasUUID(String name) {
            int[] ints = this.tag.method_10561(name);
            return ints.length == 4;
        }

        @Override
        public void putFloat(String name, float value) {
            this.tag.method_10548(name, value);
        }

        @Override
        public void putDouble(String name, double value) {
            this.tag.method_10549(name, value);
        }

        @Override
        public void putString(String name, String value) {
            this.tag.method_10582(name, value);
        }

        @Override
        public void putByteArray(String name, byte[] value) {
            this.tag.method_10570(name, value);
        }

        @Override
        public void putIntArray(String name, int[] value) {
            this.tag.method_10539(name, value);
        }

        @Override
        public void putLongArray(String name, long[] value) {
            this.tag.method_10564(name, value);
        }

        @Override
        public void putBoolean(String name, boolean value) {
            this.tag.method_10556(name, value);
        }

        @Override
        public byte getTagType(String name) {
            return this.tag.method_10540(name);
        }

        @Override
        public boolean contains(String name) {
            return this.tag.method_10545(name);
        }

        @Override
        public boolean contains(String name, int type) {
            return this.tag.method_10573(name, type);
        }

        @Override
        public byte getByte(String name) {
            return this.tag.method_10571(name);
        }

        @Override
        public short getShort(String name) {
            return this.tag.method_10568(name);
        }

        @Override
        public int getInt(String name) {
            return this.tag.method_10550(name);
        }

        @Override
        public long getLong(String name) {
            return this.tag.method_10537(name);
        }

        @Override
        public float getFloat(String name) {
            return this.tag.method_10583(name);
        }

        @Override
        public double getDouble(String name) {
            return this.tag.method_10574(name);
        }

        @Override
        @NotNull
        public String getString(String name) {
            return this.tag.method_10558(name);
        }

        @Override
        public byte[] getByteArray(String name) {
            return this.tag.method_10547(name);
        }

        @Override
        public int[] getIntArray(String name) {
            return this.tag.method_10561(name);
        }

        @Override
        public long[] getLongArray(String name) {
            return this.tag.method_10565(name);
        }

        @Override
        @NotNull
        public ICompoundTag getCompound(String name) {
            return new CompoundWrapper(this.tag.method_10562(name));
        }

        @Override
        public IListTag getList(String name, int type) {
            if (!this.tag.method_10573(name, 9)) {
                return null;
            }
            return new ListWrapper(this.tag.method_10554(name, type));
        }

        @Override
        public boolean getBoolean(String name) {
            return this.tag.method_10577(name);
        }

        @Override
        public void remove(String name) {
            this.tag.method_10551(name);
        }

        public class_2487 unwrap() {
            return this.tag;
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof class_2487) {
                return this.tag.equals(obj);
            }
            if (obj instanceof CompoundWrapper) {
                return this.tag.equals((Object)((CompoundWrapper)obj).tag);
            }
            return super.equals(obj);
        }
    }

    public static class ListWrapper
    implements IListTag {
        private final class_2499 tag;

        public ListWrapper(class_2499 tag) {
            this.tag = tag;
        }

        @Override
        public void remove(int index) {
            this.tag.method_10536(index);
        }

        @Override
        public boolean isEmpty() {
            return this.tag.size() == 0;
        }

        @Override
        public ICompoundTag getCompound(int index) {
            return new CompoundWrapper(this.tag.method_10602(index));
        }

        @Override
        @Nullable
        public IListTag getList(int index) {
            return new ListWrapper(this.tag.method_10603(index));
        }

        @Override
        public short getShort(int index) {
            return this.tag.method_10609(index);
        }

        @Override
        public int getInt(int index) {
            return this.tag.method_10600(index);
        }

        @Override
        public int[] getIntArray(int index) {
            return this.tag.method_36111(index);
        }

        @Override
        public long[] getLongArray(int index) {
            return this.tag.method_36112(index);
        }

        @Override
        public double getDouble(int index) {
            return this.tag.method_10611(index);
        }

        @Override
        public float getFloat(int index) {
            return this.tag.method_10604(index);
        }

        @Override
        public String getString(int index) {
            return this.tag.method_10608(index);
        }

        @Override
        public int size() {
            return this.tag.size();
        }

        @Override
        public void set(int index, ITag tag) {
            this.tag.method_10606(index, (class_2520)SneakyUtils.unsafeCast(tag.unwrap()));
        }

        @Override
        public void add(ITag tag) {
            this.tag.add((Object)((class_2520)SneakyUtils.unsafeCast(tag.unwrap())));
        }

        public class_2499 unwrap() {
            return this.tag;
        }
    }
}

