/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.api;

import com.almostreliable.ponderjs.mixin.SceneBuilderAccessor;
import com.almostreliable.ponderjs.particles.ParticleInstructions;
import com.almostreliable.ponderjs.util.BlockStateFunction;
import com.almostreliable.ponderjs.util.PonderPlatform;
import com.google.common.base.Preconditions;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.instruction.ShowInputInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class ExtendedSceneBuilder
extends SceneBuilder {
    private final ParticleInstructions particles;
    private final PonderScene ponderScene;

    public ExtendedSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
        this.ponderScene = ponderScene;
        ((SceneBuilderAccessor)((Object)this)).ponderjs$setWorldInstructions(new ExtendedWorldInstructions());
        ((SceneBuilderAccessor)((Object)this)).ponderjs$setSpecialInstructions(new ExtendedSpecialInstructions());
        this.particles = new ParticleInstructions(this);
    }

    public ExtendedWorldInstructions getWorld() {
        return (ExtendedWorldInstructions)this.world;
    }

    public ExtendedWorldInstructions getLevel() {
        return (ExtendedWorldInstructions)this.world;
    }

    public SceneBuilder.DebugInstructions getDebug() {
        return this.debug;
    }

    public SceneBuilder.OverlayInstructions getOverlay() {
        return this.overlay;
    }

    public SceneBuilder.EffectInstructions getEffects() {
        return this.effects;
    }

    public SceneBuilder.SpecialInstructions getSpecial() {
        return this.special;
    }

    public ParticleInstructions getParticles() {
        return this.particles;
    }

    public void showStructure() {
        this.showStructure(this.ponderScene.getBasePlateSize() * 2);
    }

    public void showStructure(int height) {
        class_2338 start = new class_2338(this.ponderScene.getBasePlateOffsetX(), 0, this.ponderScene.getBasePlateOffsetZ());
        class_2338 size = new class_2338(this.ponderScene.getBasePlateSize() - 1, height, this.ponderScene.getBasePlateSize() - 1);
        Selection selection = this.ponderScene.getSceneBuildingUtil().select.cuboid(start, (class_2382)size);
        this.encapsulateBounds(size);
        this.world.showSection(selection, class_2350.field_11036);
    }

    public void encapsulateBounds(class_2338 size) {
        this.addInstruction(ps -> {
            PonderWorld w = ps.getWorld();
            if (w != null) {
                w.getBounds().method_34389(size);
            }
        });
    }

    public void playSound(class_3414 soundEvent, class_3419 soundSource, float volume, float pitch) {
        Preconditions.checkArgument((soundEvent != null ? 1 : 0) != 0, (Object)"Given sound does not exist");
        if (class_310.method_1551().field_1724 != null) {
            this.addInstruction(ps -> {
                class_1109 sound = new class_1109(soundEvent, soundSource, volume, pitch, class_310.method_1551().field_1724.method_24515());
                class_310.method_1551().method_1483().method_4873((class_1113)sound);
            });
        }
    }

    public void playSound(class_3414 soundEvent, float volume) {
        this.playSound(soundEvent, class_3419.field_15250, volume, 1.0f);
    }

    public void playSound(class_3414 soundEvent) {
        this.playSound(soundEvent, class_3419.field_15250, 1.0f, 1.0f);
    }

    public TextWindowElement.Builder text(int duration, String text) {
        return this.overlay.showText(duration).text(text);
    }

    public TextWindowElement.Builder text(int duration, String text, class_243 position) {
        return this.overlay.showText(duration).text(text).pointAt(position);
    }

    public TextWindowElement.Builder sharedText(int duration, class_2960 key) {
        return this.overlay.showText(duration).sharedText(key);
    }

    public TextWindowElement.Builder sharedText(int duration, class_2960 key, class_243 position) {
        return this.overlay.showText(duration).sharedText(key).pointAt(position).colored(PonderPalette.BLUE);
    }

    public InputWindowElement showControls(int duration, class_243 pos, Pointing pointing) {
        InputWindowElement element = new InputWindowElement(pos, pointing);
        this.addInstruction((PonderInstruction)new ShowInputInstruction(element, duration));
        return element;
    }

    public class ExtendedWorldInstructions
    extends SceneBuilder.WorldInstructions {
        public ExtendedWorldInstructions() {
            super((SceneBuilder)ExtendedSceneBuilder.this);
        }

        public ElementLink<EntityElement> createEntity(class_1299<?> entityType, class_243 position, Consumer<EntityJS> consumer) {
            return this.createEntity(level -> {
                class_1297 entity = entityType.method_5883(level);
                Objects.requireNonNull(entity, "Could not create entity of type " + PonderPlatform.getEntityTypeName(entityType));
                entity.method_23327(position.field_1352, position.field_1351, position.field_1350);
                entity.method_22862();
                entity.method_5702(class_2183.class_2184.field_9853, position.method_1031(0.0, 0.0, -1.0));
                EntityJS entityJS = UtilsJS.getLevel((class_1937)level).getEntity(entity);
                consumer.accept(entityJS);
                return entity;
            });
        }

        public ElementLink<EntityElement> createEntity(class_1299<?> entityType, class_243 position) {
            return this.createEntity(entityType, position, entity -> {});
        }

        public void modifyBlocks(Selection pos, BlockStateFunction function) {
            this.modifyBlocks(pos, true, function);
        }

        public void modifyBlocks(Selection selection, boolean spawnParticles, BlockStateFunction function) {
            this.modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
        }

        public void modifyBlocks(Selection selection, BlockStateFunction function, boolean spawnParticles) {
            this.modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
        }

        public void modifyBlock(class_2338 pos, BlockStateFunction function, boolean spawnParticles) {
            this.modifyBlock(pos, BlockStateFunction.from(function), spawnParticles);
        }

        public void setBlocks(Selection selection, class_2680 blockState) {
            this.setBlocks(selection, true, blockState);
        }

        public void setBlocks(Selection selection, boolean spawnParticles, class_2680 blockState) {
            this.setBlocks(selection, blockState, spawnParticles);
        }

        public void modifyTileNBT(Selection selection, Consumer<class_2487> consumer) {
            this.modifyTileNBT(selection, class_2586.class, consumer, false);
        }

        public void modifyTileNBT(Selection selection, Consumer<class_2487> consumer, boolean reDrawBlocks) {
            this.modifyTileNBT(selection, class_2586.class, consumer, reDrawBlocks);
        }

        @HideFromJS
        public void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            super.modifyBlocks(selection, stateFunc, spawnParticles);
        }

        @HideFromJS
        public void modifyBlock(class_2338 pos, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            super.modifyBlock(pos, stateFunc, spawnParticles);
        }

        public void removeEntity(ElementLink<EntityElement> link) {
            ExtendedSceneBuilder.this.addInstruction(scene -> {
                EntityElement resolve = (EntityElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(class_1297::method_31472);
                }
            });
        }
    }

    public class ExtendedSpecialInstructions
    extends SceneBuilder.SpecialInstructions {
        public ExtendedSpecialInstructions() {
            super((SceneBuilder)ExtendedSceneBuilder.this);
        }

        @HideFromJS
        public void movePointOfInterest(class_2338 location) {
            super.movePointOfInterest(location);
        }
    }
}

