/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.mixin.PonderTagRegistryAccessor;
import com.google.common.collect.Multimap;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.PonderTagRegistry;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class PonderItemTagEventJS
extends EventJS {
    public void createTag(String id, ItemStackJS displayItem, String title, String description, IngredientJS ingredient) {
        PonderJS.getTagByName(id).ifPresent(tag -> {
            throw new IllegalArgumentException("Tag " + id + " already exists");
        });
        class_2960 idWithNamespace = PonderJS.appendKubeToId(id);
        PonderTag ponderTag = new PonderTag(idWithNamespace).item((class_1935)displayItem.getItem()).defaultLang(title, description);
        PonderRegistry.TAGS.listTag(ponderTag);
        this.add(ponderTag, ingredient);
        PonderJS.NAMESPACES.add(idWithNamespace.method_12836());
    }

    public void createTag(String id, ItemStackJS displayItem, String title, String description) {
        this.createTag(id, displayItem, title, description, (IngredientJS)ItemStackJS.EMPTY);
    }

    public void removeTag(PonderTag ... tags) {
        for (PonderTag tag : tags) {
            Set items = PonderRegistry.TAGS.getItems(tag);
            PonderRegistry.TAGS.getListedTags().remove(tag);
            this.remove(tag, items);
        }
    }

    public void add(PonderTag tag, IngredientJS ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        PonderTagRegistry.TagBuilder tagBuilder = PonderRegistry.TAGS.forTag(tag);
        ingredient.getStacks().forEach(stack -> tagBuilder.add((class_1935)stack.getItem()));
    }

    public void remove(PonderTag tag, IngredientJS ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        Set<class_2960> ids = ingredient.getStacks().stream().map(ItemStackJS::getId).map(class_2960::new).collect(Collectors.toSet());
        this.remove(tag, ids);
    }

    private void remove(PonderTag tag, Set<class_2960> items) {
        Multimap<class_2960, PonderTag> tagMap = ((PonderTagRegistryAccessor)PonderRegistry.TAGS).getTags();
        for (class_2960 item : items) {
            Collection tagsForItem = tagMap.get((Object)item);
            if (!tagsForItem.remove(tag)) continue;
            ConsoleJS.CLIENT.info((Object)("Removed ponder tag " + tag.getId() + " from item " + item));
        }
    }
}

