/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.util.ItemStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.common.ExtractorProxy;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.util.CCItemStorageHelpers;
import site.siredvin.peripheralium.util.ValidationHelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b!\u0010\"J#\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u00040\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJC\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014JC\u0010\u0016\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u000f\u0010\u0017\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractInventoryPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "slot", "", "", "getItemDetail", "(I)Ljava/util/Map;", "getItemLimit", "(I)I", "list", "()Ljava/util/Map;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "fromSlot", "Ljava/util/Optional;", "limit", "toSlot", "pullItems", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;ILjava/util/Optional;Ljava/util/Optional;)I", "toName", "pushItems", "size", "()I", "Ldan200/computercraft/shared/util/ItemStorage;", "getItemStorage", "()Ldan200/computercraft/shared/util/ItemStorage;", "itemStorage", "Lnet/minecraft/class_1937;", "getLevel", "()Lnet/minecraft/class_1937;", "level", "<init>", "()V", "peripheralium"})
public abstract class AbstractInventoryPlugin
implements IPeripheralPlugin {
    @NotNull
    public abstract ItemStorage getItemStorage();

    @NotNull
    public abstract class_1937 getLevel();

    @LuaFunction(mainThread=true)
    public final int size() {
        return this.getItemStorage().size();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<Integer, Map<String, ?>> list() {
        Map result = new HashMap();
        int size = this.getItemStorage().size();
        for (int i = 0; i < size; ++i) {
            Map map;
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.getItemStorage().getStack(i), (String)"itemStorage.getStack(i)");
            if (stack.method_7960()) continue;
            Map map2 = result;
            Integer n = i + 1;
            Intrinsics.checkNotNullExpressionValue((Object)ItemData.fillBasic((Map)new HashMap(4), (class_1799)stack), (String)"fillBasic(HashMap(4), stack)");
            map2.put(n, map);
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getItemDetail(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getItemStorage().size(), "slot");
        class_1799 class_17992 = this.getItemStorage().getStack(slot - 1);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"itemStorage.getStack(slot - 1)");
        class_1799 stack = class_17992;
        return stack.method_7960() ? null : ItemData.fill((Map)new HashMap(), (class_1799)stack);
    }

    @LuaFunction(mainThread=true)
    public final int getItemLimit(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getItemStorage().size(), "slot");
        return this.getItemStorage().getStack(slot - 1).method_7914();
    }

    @LuaFunction(mainThread=true)
    public final int pushItems(@NotNull IComputerAccess computer, @NotNull String toName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemStorage itemStorage = ExtractorProxy.INSTANCE.extractCCItemStorage(this.getLevel(), location.getTarget());
        if (itemStorage == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        ItemStorage toStorage = itemStorage;
        Integer n = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"limit.orElse(Int.MAX_VALUE)");
        int actualLimit = ((Number)n).intValue();
        ValidationHelpersKt.assertBetween(fromSlot, 1, this.getItemStorage().size(), "fromtSlot");
        if (toSlot.isPresent()) {
            Integer n2 = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n2).intValue(), 1, toStorage.size(), "toSlot");
        }
        return actualLimit <= 0 ? 0 : CCItemStorageHelpers.INSTANCE.moveItem(this.getItemStorage(), fromSlot - 1, toStorage, ((Number)toSlot.orElse(0)).intValue() - 1, actualLimit);
    }

    @LuaFunction(mainThread=true)
    public final int pullItems(@NotNull IComputerAccess computer, @NotNull String fromName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemStorage itemStorage = ExtractorProxy.INSTANCE.extractCCItemStorage(this.getLevel(), location.getTarget());
        if (itemStorage == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        ItemStorage fromStorage = itemStorage;
        Integer actualLimit = limit.orElse(Integer.MAX_VALUE);
        ValidationHelpersKt.assertBetween(fromSlot, 1, fromStorage.size(), "fromSlot");
        if (toSlot.isPresent()) {
            Integer n = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n).intValue(), 1, this.getItemStorage().size(), "toSlot");
        }
        Intrinsics.checkNotNullExpressionValue((Object)actualLimit, (String)"actualLimit");
        return actualLimit <= 0 ? 0 : CCItemStorageHelpers.INSTANCE.moveItem(fromStorage, fromSlot - 1, this.getItemStorage(), ((Number)toSlot.orElse(0)).intValue() - 1, actualLimit);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods(this);
    }

    @Override
    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }
}

