/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.owner;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.TurtleFuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BasePeripheralOwner;
import site.siredvin.peripheralium.util.DataStorageUtil;
import site.siredvin.peripheralium.util.world.FakePlayerProviderTurtle;
import site.siredvin.peripheralium.util.world.LibFakePlayer;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010?\u001a\u00020>\u0012\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\bC\u0010DJ\u0015\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\bJ\u001f\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0017\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ3\u0010\"\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00028\u00000\u001d2\b\u0010!\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010*\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u00100\u001a\u0004\u0018\u00010-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u0010\u0013\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0017\u00104\u001a\u0002038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0014\u0010:\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010=\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0017\u0010?\u001a\u00020>8\u0006\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\u00a8\u0006E"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BasePeripheralOwner;", "", "maxFuelConsumptionLevel", "attachFuel", "(I)Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "", "destroyUpgrade", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "isMovementPossible", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Z", "markDataStorageDirty", "move", "Lnet/minecraft/class_1799;", "stored", "storeItem", "(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "T", "Lkotlin/Function1;", "Lsite/siredvin/peripheralium/util/world/LibFakePlayer;", "function", "Lnet/minecraft/class_2350;", "overwrittenDirection", "withPlayer", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/class_2350;)Ljava/lang/Object;", "Lnet/minecraft/class_2487;", "getDataStorage", "()Lnet/minecraft/class_2487;", "dataStorage", "getFacing", "()Lnet/minecraft/class_2350;", "facing", "getLevel", "()Lnet/minecraft/class_1937;", "Lnet/minecraft/class_1657;", "getOwner", "()Lnet/minecraft/class_1657;", "owner", "getPos", "()Lnet/minecraft/class_2338;", "Ldan200/computercraft/api/turtle/TurtleSide;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "getSide", "()Ldan200/computercraft/api/turtle/TurtleSide;", "getTargetRepresentation", "()Ljava/lang/Object;", "targetRepresentation", "getToolInMainHand", "()Lnet/minecraft/class_1799;", "toolInMainHand", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "getTurtle", "()Ldan200/computercraft/api/turtle/ITurtleAccess;", "<init>", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)V", "peripheralium"})
public final class TurtlePeripheralOwner
extends BasePeripheralOwner {
    @NotNull
    private final ITurtleAccess turtle;
    @NotNull
    private final TurtleSide side;

    public TurtlePeripheralOwner(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.turtle = turtle;
        this.side = side;
    }

    @NotNull
    public final ITurtleAccess getTurtle() {
        return this.turtle;
    }

    @NotNull
    public final TurtleSide getSide() {
        return this.side;
    }

    @Override
    @NotNull
    public class_1937 getLevel() {
        class_1937 class_19372 = this.turtle.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"turtle.level");
        return class_19372;
    }

    @Override
    @NotNull
    public class_2338 getPos() {
        class_2338 class_23382 = this.turtle.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"turtle.position");
        return class_23382;
    }

    @Override
    @NotNull
    public class_2350 getFacing() {
        class_2350 class_23502 = this.turtle.getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"turtle.direction");
        return class_23502;
    }

    @Override
    @NotNull
    public Object getTargetRepresentation() {
        return this.turtle;
    }

    @Override
    @Nullable
    public class_1657 getOwner() {
        GameProfile gameProfile = this.turtle.getOwningPlayer();
        if (gameProfile == null) {
            return null;
        }
        GameProfile owningPlayer = gameProfile;
        return this.turtle.getLevel().method_18470(owningPlayer.getId());
    }

    @Override
    @NotNull
    public class_2487 getDataStorage() {
        return DataStorageUtil.INSTANCE.getDataStorage(this.turtle, this.side);
    }

    @Override
    public void markDataStorageDirty() {
        this.turtle.updateUpgradeNBTData(this.side);
    }

    @Override
    public <T> T withPlayer(@NotNull Function1<? super LibFakePlayer, ? extends T> function, @Nullable class_2350 overwrittenDirection) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return (T)FakePlayerProviderTurtle.INSTANCE.withPlayer(this.turtle, arg_0 -> TurtlePeripheralOwner.withPlayer$lambda$0(function, arg_0), overwrittenDirection);
    }

    @Override
    @NotNull
    public class_1799 getToolInMainHand() {
        class_1799 class_17992 = this.turtle.getInventory().method_5438(this.turtle.getSelectedSlot());
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"turtle.inventory.getItem(turtle.selectedSlot)");
        return class_17992;
    }

    @Override
    @NotNull
    public class_1799 storeItem(@NotNull class_1799 stored) {
        Intrinsics.checkNotNullParameter((Object)stored, (String)"stored");
        class_1799 class_17992 = InventoryUtil.storeItems((class_1799)stored, (ItemStorage)this.turtle.getItemHandler(), (int)this.turtle.getSelectedSlot());
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"storeItems(stored, turtl\u2026ler, turtle.selectedSlot)");
        return class_17992;
    }

    @Override
    public void destroyUpgrade() {
        this.turtle.setUpgrade(this.side, null);
    }

    @Override
    public boolean isMovementPossible(@NotNull class_1937 level, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (Boolean)FakePlayerProviderTurtle.withPlayer$default(FakePlayerProviderTurtle.INSTANCE, this.turtle, arg_0 -> TurtlePeripheralOwner.isMovementPossible$lambda$1(level, pos, arg_0), null, 4, null);
    }

    @Override
    public boolean move(@NotNull class_1937 level, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.turtle.teleportTo(level, pos);
    }

    @NotNull
    public final TurtlePeripheralOwner attachFuel(int maxFuelConsumptionLevel) {
        this.attachAbility(PeripheralOwnerAbility.Companion.getFUEL(), (IOwnerAbility)new TurtleFuelAbility(this, maxFuelConsumptionLevel));
        return this;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TurtlePeripheralOwner)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((TurtlePeripheralOwner)other).turtle, (Object)this.turtle) && ((TurtlePeripheralOwner)other).side == this.side;
    }

    public int hashCode() {
        int result = this.turtle.hashCode();
        result = 31 * result + this.side.hashCode();
        return result;
    }

    private static final Object withPlayer$lambda$0(Function1 $tmp0, LibFakePlayer p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
        return $tmp0.invoke((Object)p0);
    }

    private static final Boolean isMovementPossible$lambda$1(class_1937 $level, class_2338 $pos, LibFakePlayer player) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        if ($level.method_31606($pos)) {
            return false;
        }
        if (!$level.method_24794($pos)) {
            return false;
        }
        if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEnterable((class_1937)$level, (class_2338)$pos, (class_1657)((class_1657)player))) {
            return false;
        }
        if (!$level.method_8477($pos)) {
            return false;
        }
        return $level.method_8621().method_11952($pos);
    }
}

