/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.util.obj;

import immersive_aircraft.util.obj.Face;
import immersive_aircraft.util.obj.FaceVertex;
import immersive_aircraft.util.obj.Mesh;
import immersive_aircraft.util.obj.StringUtils;
import immersive_aircraft.util.obj.VertexColor;
import immersive_aircraft.util.obj.VertexNormal;
import immersive_aircraft.util.obj.VertexPosition;
import immersive_aircraft.util.obj.VertexTexture;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Builder {
    private final Logger log = Logger.getLogger(Builder.class.getName());
    public static final int EMPTY_VERTEX_VALUE = Integer.MIN_VALUE;
    public final ArrayList<VertexPosition> verticesG = new ArrayList();
    public final ArrayList<VertexColor> verticesC = new ArrayList();
    public final ArrayList<VertexTexture> verticesT = new ArrayList();
    public final ArrayList<VertexNormal> verticesN = new ArrayList();
    final HashMap<String, FaceVertex> faceVertexMap = new HashMap();
    public final ArrayList<FaceVertex> faceVertexList = new ArrayList();
    public final Map<String, Mesh> objects = new HashMap<String, Mesh>();
    public String objectName = null;
    public int faceTriCount = 0;
    public int faceQuadCount = 0;
    public int facePolyCount = 0;
    public int faceErrorCount = 0;
    private static final String OBJ_VERTEX_TEXTURE = "vt";
    private static final String OBJ_VERTEX_NORMAL = "vn";
    private static final String OBJ_VERTEX = "v";
    private static final String OBJ_FACE = "f";
    private static final String OBJ_OBJECT_NAME = "o";

    public Builder(BufferedReader stream) throws IOException {
        String line;
        while (null != (line = stream.readLine())) {
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith(OBJ_VERTEX_TEXTURE)) {
                this.processVertexTexture(line);
                continue;
            }
            if (line.startsWith(OBJ_VERTEX_NORMAL)) {
                this.processVertexNormal(line);
                continue;
            }
            if (line.startsWith(OBJ_VERTEX)) {
                this.processVertex(line);
                continue;
            }
            if (line.startsWith(OBJ_FACE)) {
                this.processFace(line);
                continue;
            }
            if (!line.startsWith(OBJ_OBJECT_NAME)) continue;
            this.processObjectName(line);
        }
    }

    private void processVertex(String line) {
        float[] values = StringUtils.parseFloatList(7, line, OBJ_VERTEX.length());
        this.addVertexGeometric(values[0], values[1], values[2]);
        this.addVertexColor(values[3], values[4], values[5], values[6]);
    }

    private void processVertexTexture(String line) {
        float[] values = StringUtils.parseFloatList(2, line, OBJ_VERTEX_TEXTURE.length());
        this.addVertexTexture(values[0], 1.0f - values[1]);
    }

    private void processVertexNormal(String line) {
        float[] values = StringUtils.parseFloatList(3, line, OBJ_VERTEX_NORMAL.length());
        this.addVertexNormal(values[0], values[1], values[2]);
    }

    private void processFace(String line) {
        line = line.substring(OBJ_FACE.length()).trim();
        this.addFace(StringUtils.parseListVerticeNTuples(line, 3));
    }

    private void processObjectName(String line) {
        this.addObjectName(line.substring(OBJ_OBJECT_NAME.length()).trim());
    }

    public void addVertexGeometric(float x, float y, float z) {
        this.verticesG.add(new VertexPosition(x, y, z));
    }

    public void addVertexColor(float r, float g, float b, float a) {
        this.verticesC.add(new VertexColor(r, g, b, a));
    }

    public void addVertexTexture(float u, float v) {
        this.verticesT.add(new VertexTexture(u, v));
    }

    public void addVertexNormal(float x, float y, float z) {
        this.verticesN.add(new VertexNormal(x, y, z));
    }

    public void addFace(int[] vertexIndices) {
        Face face = new Face();
        int i = 0;
        while (i < vertexIndices.length) {
            int vertexIndex;
            FaceVertex fv = new FaceVertex();
            if ((vertexIndex = vertexIndices[i++]) < 0) {
                vertexIndex += this.verticesG.size();
            }
            if (vertexIndex - 1 >= 0 && vertexIndex - 1 < this.verticesG.size()) {
                fv.v = this.verticesG.get(vertexIndex - 1);
                fv.c = this.verticesC.get(vertexIndex - 1);
            } else {
                this.log.log(Level.SEVERE, "Index for geometric vertex=" + vertexIndex + " is out of the current range of geometric vertex values 1 to " + this.verticesG.size() + ", ignoring");
            }
            vertexIndex = vertexIndices[i++];
            if (vertexIndex != Integer.MIN_VALUE) {
                if (vertexIndex < 0) {
                    vertexIndex += this.verticesT.size();
                }
                if (vertexIndex - 1 >= 0 && vertexIndex - 1 < this.verticesT.size()) {
                    fv.t = this.verticesT.get(vertexIndex - 1);
                } else {
                    this.log.log(Level.SEVERE, "Index for texture vertex=" + vertexIndex + " is out of the current range of texture vertex values 1 to " + this.verticesT.size() + ", ignoring");
                }
            }
            if ((vertexIndex = vertexIndices[i++]) != Integer.MIN_VALUE) {
                if (vertexIndex < 0) {
                    vertexIndex += this.verticesN.size();
                }
                if (vertexIndex - 1 >= 0 && vertexIndex - 1 < this.verticesN.size()) {
                    fv.n = this.verticesN.get(vertexIndex - 1);
                } else {
                    this.log.log(Level.SEVERE, "Index for vertex normal=" + vertexIndex + " is out of the current range of vertex normal values 1 to " + this.verticesN.size() + ", ignoring");
                }
            }
            if (fv.v == null) {
                this.log.log(Level.SEVERE, "Can't add vertex to face with missing vertex!  Throwing away face.");
                ++this.faceErrorCount;
                return;
            }
            String key = fv.toString();
            FaceVertex fv2 = this.faceVertexMap.get(key);
            if (null == fv2) {
                this.faceVertexMap.put(key, fv);
                fv.index = this.faceVertexList.size();
                this.faceVertexList.add(fv);
            } else {
                fv = fv2;
            }
            face.add(fv);
        }
        if (this.objectName == null) {
            this.objectName = "unnamed";
            this.objects.put(this.objectName, new Mesh());
        }
        this.objects.get(this.objectName).add(face);
        if (face.vertices.size() == 3) {
            ++this.faceTriCount;
        } else if (face.vertices.size() == 4) {
            ++this.faceQuadCount;
        } else {
            ++this.facePolyCount;
        }
    }

    public void addObjectName(String name) {
        this.objectName = name;
        this.objects.put(this.objectName, new Mesh());
    }
}

