/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.mixins;

import com.google.common.io.BaseEncoding;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.util.NBTUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import site.siredvin.peripheralworks.DigestOutputStream;

@Mixin(value={NBTUtil.class})
public class NBTUtilMixin {
    @Final
    private static BaseEncoding ENCODING;

    @Inject(method={"getNBTHash"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getNBTHash(@Nullable class_2487 tag, CallbackInfoReturnable<String> cir) {
        if (tag == null) {
            cir.setReturnValue(null);
        } else {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
                NBTUtilMixin.writeNamedTag(output, "", (class_2520)NBTUtilMixin.assertNonNull(tag));
                byte[] hash = digest.digest();
                cir.setReturnValue((Object)ENCODING.encode(hash));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                ComputerCraft.log.error("Cannot hash NBT", (Throwable)e);
                cir.setReturnValue(null);
            }
        }
    }

    private static void writeNamedTag(DataOutput output, String name, class_2520 tag) throws IOException {
        output.writeByte(tag.method_10711());
        if (tag.method_10711() == 0) {
            return;
        }
        output.writeUTF(name);
        NBTUtilMixin.writeTag(output, tag);
    }

    private static <T> T assertNonNull(T value) {
        if (value == null) {
            throw new NullPointerException("Well, that's really something, how did you even get here?");
        }
        return value;
    }

    private static void writeTag(DataOutput output, class_2520 tag) throws IOException {
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            Object[] keys = compound.method_10541().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtilMixin.writeNamedTag(output, (String)key, NBTUtilMixin.assertNonNull(compound.method_10580((String)key)));
            }
            output.writeByte(0);
        } else if (tag instanceof class_2499) {
            class_2499 list = (class_2499)tag;
            output.writeByte(list.isEmpty() ? 0 : (int)list.method_10534(0).method_10711());
            output.writeInt(list.size());
            for (class_2520 value : list) {
                NBTUtilMixin.writeTag(output, value);
            }
        } else {
            tag.method_10713(output);
        }
    }
}

