/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.lifts;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import io.github.lucaargolo.lifts.common.blockentity.lift.ElectricLiftBlockEntity;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftActionResult;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftBlockEntity;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftShaft;
import io.github.lucaargolo.lifts.common.blockentity.lift.StirlingLiftBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.integrations.lifts.Configuration;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 )2\u00020\u0001:\u0002)*B\u000f\u0012\u0006\u0010%\u001a\u00020\u0012\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b0\u0007H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ-\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b \u0010!J-\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001b2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lsite/siredvin/peripheralworks/integrations/lifts/LiftPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "floor", "Ldan200/computercraft/api/lua/MethodResult;", "changeFloor", "(I)Ldan200/computercraft/api/lua/MethodResult;", "", "", "", "", "floors", "()Ljava/util/List;", "getCurrentFloor", "()Ldan200/computercraft/api/lua/MethodResult;", "index", "getFloorName", "(I)Ljava/lang/String;", "Lio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;", "lift", "Lnet/minecraft/class_2561;", "getLiftName", "(ILio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;)Lnet/minecraft/class_2561;", "getLiftNameRaw", "(I)Lnet/minecraft/class_2561;", "reverseNumber", "(I)I", "", "toLua", "(ILio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;)Ljava/util/Map;", "toLuaBase", "Lio/github/lucaargolo/lifts/common/blockentity/lift/ElectricLiftBlockEntity;", "toLuaElectric", "(ILio/github/lucaargolo/lifts/common/blockentity/lift/ElectricLiftBlockEntity;)Ljava/util/Map;", "Lio/github/lucaargolo/lifts/common/blockentity/lift/StirlingLiftBlockEntity;", "toLuaStirling", "(ILio/github/lucaargolo/lifts/common/blockentity/lift/StirlingLiftBlockEntity;)Ljava/util/Map;", "entity", "Lio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;", "<init>", "(Lio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;)V", "Companion", "Provider", "peripheralworks"})
public final class LiftPlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LiftBlockEntity entity;
    @NotNull
    public static final String PLUGIN_TYPE = "lift";

    public LiftPlugin(@NotNull LiftBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entity = entity;
    }

    private final int reverseNumber(int index) {
        LiftShaft liftShaft = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft);
        return liftShaft.getSize() - index;
    }

    private final class_2561 getLiftNameRaw(int index) {
        int floor = this.reverseNumber(index);
        String suffix = switch (floor) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
        class_5250 class_52502 = new class_2585(String.valueOf(floor)).method_10852((class_2561)new class_2588("screen.lifts.number." + suffix)).method_27693(" ").method_10852((class_2561)new class_2588("screen.lifts.common.floor"));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"TextComponent(floor.toSt\u2026en.lifts.common.floor\") )");
        return (class_2561)class_52502;
    }

    private final class_2561 getLiftName(int index, LiftBlockEntity lift) {
        if (lift.getLiftName() != null) {
            String string = lift.getLiftName();
            Intrinsics.checkNotNull((Object)string);
            return (class_2561)new class_2585(string);
        }
        return this.getLiftNameRaw(index);
    }

    private final Map<String, Object> toLuaBase(int index, LiftBlockEntity lift) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)this.getLiftName(index, lift).getString()), TuplesKt.to((Object)"ready", (Object)lift.getReady()), TuplesKt.to((Object)"number", (Object)this.reverseNumber(index))};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final Map<String, Object> toLuaElectric(int index, ElectricLiftBlockEntity lift) {
        Map<String, Object> base;
        Map<String, Object> map = base = this.toLuaBase(index, (LiftBlockEntity)lift);
        String string = "energy";
        Object object = new Pair[]{TuplesKt.to((Object)"amount", (Object)lift.getEnergyStorage().amount), TuplesKt.to((Object)"capacity", (Object)lift.getEnergyStorage().capacity)};
        object = MapsKt.hashMapOf((Pair[])object);
        map.put(string, object);
        return base;
    }

    private final Map<String, Object> toLuaStirling(int index, StirlingLiftBlockEntity lift) {
        Map<String, Object> base = this.toLuaBase(index, (LiftBlockEntity)lift);
        lift.getPropertyDelegate();
        Map<String, Object> map = base;
        String string = "generator";
        Object object = new Pair[]{TuplesKt.to((Object)"burningTicks", (Object)lift.getPropertyDelegate().method_17390(1)), TuplesKt.to((Object)"storedTicks", (Object)lift.getPropertyDelegate().method_17390(2))};
        object = MapsKt.hashMapOf((Pair[])object);
        map.put(string, object);
        return base;
    }

    private final Map<String, Object> toLua(int index, LiftBlockEntity lift) {
        if (lift instanceof StirlingLiftBlockEntity) {
            return this.toLuaStirling(index, (StirlingLiftBlockEntity)lift);
        }
        if (lift instanceof ElectricLiftBlockEntity) {
            return this.toLuaElectric(index, (ElectricLiftBlockEntity)lift);
        }
        return this.toLuaBase(index, lift);
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, Object>> floors() {
        void $this$mapIndexedTo$iv$iv;
        if (this.entity.getLiftShaft() == null) {
            return CollectionsKt.listOf(this.toLua(0, this.entity));
        }
        LiftShaft liftShaft = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft);
        Iterable $this$mapIndexed$iv = liftShaft.getLifts();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LiftBlockEntity liftBlockEntity = (LiftBlockEntity)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.toLua((int)index, (LiftBlockEntity)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final String getFloorName(int index) {
        ValidationHelpersKt.assertBetween((int)index, (int)1, (int)Integer.MAX_VALUE, (String)"Floor should be positive integer");
        int realIndex = this.reverseNumber(index);
        if (this.entity.getLiftShaft() == null) {
            String string = this.getLiftNameRaw(realIndex).getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiftNameRaw(realIndex).string");
            return string;
        }
        LiftShaft liftShaft = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft);
        int maxFloor = liftShaft.getLifts().size();
        ValidationHelpersKt.assertBetween((int)index, (int)1, (int)maxFloor, (String)("There is only " + maxFloor + " present"));
        LiftShaft liftShaft2 = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft2);
        Iterable $this$forEachIndexed$iv = liftShaft2.getLifts();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void liftBlockEntity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LiftBlockEntity liftBlockEntity2 = (LiftBlockEntity)item$iv;
            int internal_index = n;
            boolean bl = false;
            if (internal_index != realIndex) continue;
            Intrinsics.checkNotNullExpressionValue((Object)liftBlockEntity, (String)"liftBlockEntity");
            String string = this.getLiftName(realIndex, (LiftBlockEntity)liftBlockEntity).getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiftName(realIndex, liftBlockEntity).string");
            return string;
        }
        String string = this.getLiftNameRaw(realIndex).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiftNameRaw(realIndex).string");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getCurrentFloor() {
        if (this.entity.getLiftShaft() == null) {
            Object[] objectArray = new Object[]{null, "Lift shaft are not exists"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Lift shaft are not exists\")");
            return methodResult;
        }
        LiftShaft liftShaft = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft);
        Iterable $this$forEachIndexed$iv = liftShaft.getLifts();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void liftBlockEntity;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            LiftBlockEntity liftBlockEntity2 = (LiftBlockEntity)item$iv;
            int index = n;
            boolean bl = false;
            if (!liftBlockEntity.isPlatformHere()) continue;
            MethodResult methodResult = MethodResult.of((Object)this.reverseNumber(index));
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(reverseNumber(index))");
            return methodResult;
        }
        Object[] objectArray = new Object[]{null, "Seems platform on the way"};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Seems platform on the way\")");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult changeFloor(int floor) {
        int index = this.reverseNumber(floor);
        LiftShaft liftShaft = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft);
        LiftBlockEntity liftBlockEntity = (LiftBlockEntity)CollectionsKt.elementAtOrNull((Iterable)liftShaft.getLifts(), (int)index);
        if (liftBlockEntity == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            LiftShaft liftShaft2 = this.entity.getLiftShaft();
            Intrinsics.checkNotNull((Object)liftShaft2);
            objectArray[1] = "Floor should be from 1 to " + liftShaft2.getSize();
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Floor should b\u2026ntity.liftShaft!!.size}\")");
            return methodResult;
        }
        LiftBlockEntity targetLift = liftBlockEntity;
        LiftShaft liftShaft3 = this.entity.getLiftShaft();
        Intrinsics.checkNotNull((Object)liftShaft3);
        class_1937 class_19372 = this.entity.method_10997();
        Intrinsics.checkNotNull((Object)class_19372);
        LiftActionResult result = liftShaft3.sendPlatformTo(class_19372, targetLift, false);
        if (!result.isAccepted()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            Intrinsics.checkNotNullExpressionValue((Object)result.name().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, result.name.lowercase())");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType((IPeripheralPlugin)this);
    }

    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IPluggablePeripheral)value);
    }

    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this);
    }

    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralworks/integrations/lifts/LiftPlugin$Companion;", "", "", "PLUGIN_TYPE", "Ljava/lang/String;", "<init>", "()V", "peripheralworks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/peripheralworks/integrations/lifts/LiftPlugin$Provider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2350;", "side", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "provide", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "getPluginType", "()Ljava/lang/String;", "pluginType", "<init>", "()V", "peripheralworks"})
    public static final class Provider
    implements PeripheralPluginProvider {
        @Override
        @NotNull
        public String getPluginType() {
            return LiftPlugin.PLUGIN_TYPE;
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2350 side) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (!Configuration.INSTANCE.getEnableLift()) {
                return null;
            }
            class_2586 entity = level.method_8321(pos);
            if (!(entity instanceof LiftBlockEntity)) {
                return null;
            }
            return new LiftPlugin((LiftBlockEntity)entity);
        }

        @Override
        public int getPriority() {
            return PeripheralPluginProvider.DefaultImpls.getPriority(this);
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            return PeripheralPluginProvider.DefaultImpls.getConflictWith(this);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }
}

