/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralworks.integrations.ae2;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.pathing.IPathingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.blockentity.grid.AENetworkBlockEntity;
import com.google.common.collect.ImmutableSet;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.common.ExtractorProxy;
import site.siredvin.peripheralium.common.configuration.PeripheraliumConfig;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralworks.api.PeripheralPluginProvider;
import site.siredvin.peripheralworks.integrations.ae2.AE2Helper;
import site.siredvin.peripheralworks.integrations.ae2.Configuration;
import site.siredvin.peripheralworks.integrations.ae2.MENetworkBlockPlugin;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u000278B\u0017\u0012\u0006\u00103\u001a\u000202\u0012\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b5\u00106J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\t\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\t\u0010\u0007J\u001b\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0010\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n0\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n0\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001f\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n0\u000fH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0007J\u000f\u0010\u0015\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0007J/\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n0\u000f2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0004J;\u0010\"\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007\u00a2\u0006\u0004\b\"\u0010#J;\u0010%\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007\u00a2\u0006\u0004\b%\u0010&J;\u0010(\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007\u00a2\u0006\u0004\b(\u0010#J;\u0010)\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007\u00a2\u0006\u0004\b)\u0010&J;\u0010,\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010.\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n0\u000fH\u0007\u00a2\u0006\u0004\b.\u0010\u0011R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00103\u001a\u0002028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00069"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "Ldan200/computercraft/api/lua/MethodResult;", "getActiveCraftings", "()Ldan200/computercraft/api/lua/MethodResult;", "", "getAverageEnergyDemand", "()D", "getAverageEnergyIncome", "getChannelEnergyDemand", "", "", "", "getChannelInformation", "()Ljava/util/Map;", "", "getCraftableFluids", "()Ljava/util/List;", "getCraftableItems", "getCraftingCPUs", "getEnergy", "getEnergyCapacity", "mode", "id_key", "getPatternsFor", "(Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "items", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "Ljava/util/Optional;", "", "limit", "fluidName", "pullFluid", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/util/Optional;Ljava/util/Optional;)D", "itemName", "pullItem", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/util/Optional;Ljava/util/Optional;)J", "toName", "pushFluid", "pushItem", "amount", "targetCPU", "scheduleCrafting", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Optional;Ljava/util/Optional;)Ldan200/computercraft/api/lua/MethodResult;", "tanks", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "entity", "Lappeng/blockentity/grid/AENetworkBlockEntity;", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1937;", "<init>", "(Lnet/minecraft/class_1937;Lappeng/blockentity/grid/AENetworkBlockEntity;)V", "Companion", "Provider", "peripheralworks"})
public final class MENetworkBlockPlugin
implements IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_1937 level;
    @NotNull
    private final AENetworkBlockEntity entity;
    @NotNull
    public static final String PLUGIN_TYPE = "ae2";

    public MENetworkBlockPlugin(@NotNull class_1937 level, @NotNull AENetworkBlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.level = level;
        this.entity = entity;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult items() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        MEStorage mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
        if (mEStorage == null) {
            throw new LuaException("Not correctly configured AE2 Network");
        }
        MEStorage inventory = mEStorage;
        KeyCounter keyCounter = inventory.getAvailableStacks();
        Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"inventory.availableStacks");
        MethodResult methodResult = MethodResult.of((Object)AE2Helper.keyCounterToLua$default(AE2Helper.INSTANCE, keyCounter, MENetworkBlockPlugin::items$lambda$0, false, 4, null));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(keyCounterToLua(inven\u2026acks, {it is AEItemKey}))");
        return methodResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    public final long pushItem(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<String> itemName, @NotNull Optional<Long> limit) {
        long l;
        Object v7;
        MEStorage inventory;
        Storage toStorage;
        block20: {
            Predicate<AEItemKey> predicate;
            IPeripheral iPeripheral;
            Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
            Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
            Intrinsics.checkNotNullParameter(itemName, (String)"itemName");
            Intrinsics.checkNotNullParameter(limit, (String)"limit");
            if (limit.isPresent()) {
                Long l2 = limit.get();
                long l3 = 0L;
                if (l2 != null && l2 == l3) {
                    return 0L;
                }
            }
            if ((iPeripheral = computer.getAvailablePeripheral(toName)) == null) {
                throw new LuaException("Target '" + toName + "' does not exist");
            }
            IPeripheral location = iPeripheral;
            Storage storage = ExtractorProxy.INSTANCE.extractItemStorage(this.level, location.getTarget());
            if (storage == null) {
                throw new LuaException("Target '" + toName + "' is not an fluid inventory");
            }
            toStorage = storage;
            if (itemName.isEmpty()) {
                predicate = MENetworkBlockPlugin::pushItem$lambda$1;
            } else {
                Object object = class_2378.field_11142.method_10223(new class_2960(itemName.get()));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(ResourceLocation(itemName.get()))");
                class_1792 item = (class_1792)object;
                if (Intrinsics.areEqual((Object)item, (Object)class_1802.field_8162)) {
                    throw new LuaException("There is no item " + itemName.get());
                }
                predicate = arg_0 -> MENetworkBlockPlugin.pushItem$lambda$2(item, arg_0);
            }
            Predicate<AEItemKey> predicate2 = predicate;
            IGrid iGrid = this.entity.getMainNode().getGrid();
            MEStorage mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
            if (mEStorage == null) {
                throw new LuaException("Not correctly configured AE2 Network");
            }
            inventory = mEStorage;
            KeyCounter keyCounter = inventory.getAvailableStacks();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"inventory.availableStacks");
            Iterable iterable = (Iterable)keyCounter;
            for (Object t : iterable) {
                Object2LongMap.Entry it = (Object2LongMap.Entry)t;
                boolean bl = false;
                AEKey aeKey = (AEKey)it.getKey();
                if (!(!(aeKey instanceof AEItemKey) ? false : predicate2.test((AEItemKey)aeKey))) continue;
                v7 = t;
                break block20;
            }
            v7 = null;
        }
        Object2LongMap.Entry entry = v7;
        if (entry == null) {
            return 0L;
        }
        Object2LongMap.Entry itemToTransfer = entry;
        if (!(itemToTransfer.getKey() instanceof AEItemKey)) {
            return 0L;
        }
        long l4 = PeripheraliumConfig.INSTANCE.getItemStorageTransferLimit();
        Long l5 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l5, (String)"limit.orElse(Long.MAX_VALUE)");
        long l6 = ((Number)l5).longValue();
        l4 = Math.min(l4, l6);
        l6 = itemToTransfer.getLongValue();
        long realLimit2 = Math.min(l4, l6);
        long extractedLimit = inventory.extract((AEKey)itemToTransfer.getKey(), realLimit2, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        Object object = itemToTransfer.getKey();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type appeng.api.stacks.AEItemKey");
        class_1799 transferStack = ((AEItemKey)object).toStack((int)extractedLimit);
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            long l7;
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long insertedAmount = toStorage.insert((Object)ItemVariant.of((class_1799)transferStack), extractedLimit, (TransactionContext)it);
            if (insertedAmount == 0L) {
                it.abort();
                l7 = 0L;
            } else {
                long extractedAmount = inventory.extract((AEKey)itemToTransfer.getKey(), realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                if (extractedAmount != insertedAmount) {
                    inventory.insert((AEKey)itemToTransfer.getKey(), realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                    it.abort();
                    l7 = 0L;
                } else {
                    it.commit();
                    l7 = extractedAmount;
                }
            }
            l = l7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    public final long pullItem(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<String> itemName, @NotNull Optional<Long> limit) {
        long l;
        Predicate<ItemVariant> predicate;
        IPeripheral iPeripheral;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(itemName, (String)"itemName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        if (limit.isPresent()) {
            Long l2 = limit.get();
            long l3 = 0L;
            if (l2 != null && l2 == l3) {
                return 0L;
            }
        }
        if ((iPeripheral = computer.getAvailablePeripheral(fromName)) == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Storage storage = ExtractorProxy.INSTANCE.extractItemStorage(this.level, location.getTarget());
        if (storage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        Storage fromStorage = storage;
        if (itemName.isEmpty()) {
            predicate = MENetworkBlockPlugin::pullItem$lambda$5;
        } else {
            Object object = class_2378.field_11142.method_10223(new class_2960(itemName.get()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(ResourceLocation(itemName.get()))");
            class_1792 item = (class_1792)object;
            if (Intrinsics.areEqual((Object)item, (Object)class_1802.field_8162)) {
                throw new LuaException("There is no item " + itemName.get());
            }
            predicate = arg_0 -> MENetworkBlockPlugin.pullItem$lambda$6(item, arg_0);
        }
        Predicate<ItemVariant> predicate2 = predicate;
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            long l4;
            MEStorage mEStorage;
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            ResourceAmount resourceAmount = StorageUtil.findExtractableContent((Storage)fromStorage, predicate2, (TransactionContext)((TransactionContext)it));
            if (resourceAmount == null) {
                long l5 = 0L;
                return l5;
            }
            Intrinsics.checkNotNullExpressionValue((Object)resourceAmount, (String)"StorageUtil.findExtracta\u2026redicate, it) ?: return 0");
            ResourceAmount extractableResource = resourceAmount;
            IGrid iGrid = this.entity.getMainNode().getGrid();
            MEStorage mEStorage2 = mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
            if (mEStorage2 == null) {
                throw new LuaException("Not correctly configured AE2 Network");
            }
            Intrinsics.checkNotNullExpressionValue((Object)mEStorage2, (String)"entity.mainNode.grid?.st\u2026 configured AE2 Network\")");
            MEStorage inventory = mEStorage;
            AEItemKey aeKey = AEItemKey.of((ItemVariant)((ItemVariant)extractableResource.resource()));
            long l6 = PeripheraliumConfig.INSTANCE.getItemStorageTransferLimit();
            Long l7 = limit.orElse(Long.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)l7, (String)"limit.orElse(Long.MAX_VALUE)");
            long l8 = ((Number)l7).longValue();
            l6 = Math.min(l6, l8);
            l8 = extractableResource.amount();
            long realLimit2 = Math.min(l6, l8);
            long insertLimit = inventory.insert((AEKey)aeKey, realLimit2, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
            if (insertLimit == 0L) {
                it.abort();
                l4 = 0L;
            } else {
                long extractedAmount = fromStorage.extract(extractableResource.resource(), realLimit2, (TransactionContext)it);
                if (extractedAmount == 0L) {
                    it.abort();
                    l4 = 0L;
                } else {
                    long insertedAmount = inventory.insert((AEKey)aeKey, realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                    if (extractedAmount != insertedAmount) {
                        inventory.extract((AEKey)aeKey, realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                        it.abort();
                        l4 = 0L;
                    } else {
                        it.commit();
                        l4 = insertedAmount;
                    }
                }
            }
            l = l4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return l;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> tanks() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        MEStorage mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
        if (mEStorage == null) {
            throw new LuaException("Not correctly configured AE2 Network");
        }
        MEStorage inventory = mEStorage;
        KeyCounter keyCounter = inventory.getAvailableStacks();
        Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"inventory.availableStacks");
        return AE2Helper.keyCounterToLua$default(AE2Helper.INSTANCE, keyCounter, MENetworkBlockPlugin::tanks$lambda$8, false, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    public final double pushFluid(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        double d;
        Object v7;
        Object object3;
        MEStorage inventory;
        Storage toStorage;
        block20: {
            Predicate<AEFluidKey> predicate;
            IPeripheral iPeripheral;
            Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
            Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
            Intrinsics.checkNotNullParameter(limit, (String)"limit");
            Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
            if (limit.isPresent()) {
                Long l = limit.get();
                long l2 = 0L;
                if (l != null && l == l2) {
                    return 0.0;
                }
            }
            if ((iPeripheral = computer.getAvailablePeripheral(toName)) == null) {
                throw new LuaException("Target '" + toName + "' does not exist");
            }
            IPeripheral location = iPeripheral;
            Storage storage = ExtractorProxy.INSTANCE.extractFluidStorage(this.level, location.getTarget());
            if (storage == null) {
                throw new LuaException("Target '" + toName + "' is not an fluid inventory");
            }
            toStorage = storage;
            if (fluidName.isEmpty()) {
                predicate = MENetworkBlockPlugin::pushFluid$lambda$9;
            } else {
                Object object2 = class_2378.field_11154.method_10223(new class_2960(fluidName.get()));
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"FLUID.get(ResourceLocation(fluidName.get()))");
                class_3611 fluid = (class_3611)object2;
                if (Intrinsics.areEqual((Object)fluid, (Object)class_3612.field_15906)) {
                    throw new LuaException("There is no fluid " + fluidName.get());
                }
                predicate = arg_0 -> MENetworkBlockPlugin.pushFluid$lambda$10(fluid, arg_0);
            }
            Predicate<AEFluidKey> predicate2 = predicate;
            IGrid iGrid = this.entity.getMainNode().getGrid();
            MEStorage mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
            if (mEStorage == null) {
                throw new LuaException("Not correctly configured AE2 Network");
            }
            inventory = mEStorage;
            KeyCounter keyCounter = inventory.getAvailableStacks();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"inventory.availableStacks");
            Iterable iterable = (Iterable)keyCounter;
            for (Object object3 : iterable) {
                Object2LongMap.Entry it = (Object2LongMap.Entry)object3;
                boolean bl = false;
                AEKey aeKey = (AEKey)it.getKey();
                if (!(!(aeKey instanceof AEFluidKey) ? false : predicate2.test((AEFluidKey)aeKey))) continue;
                v7 = object3;
                break block20;
            }
            v7 = null;
        }
        Object2LongMap.Entry entry = v7;
        if (entry == null) {
            return 0.0;
        }
        Object2LongMap.Entry fluidToTransfer = entry;
        if (!(fluidToTransfer.getKey() instanceof AEFluidKey)) {
            return 0.0;
        }
        long l = PeripheraliumConfig.INSTANCE.getFluidStorageTransferLimit();
        object3 = limit.map(arg_0 -> MENetworkBlockPlugin.pushFluid$lambda$12(pushFluid.realLimit.1.INSTANCE, arg_0)).orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue(object3, (String)"limit.map {\n            \u2026 }.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)object3).longValue();
        l = Math.min(l, l3);
        l3 = fluidToTransfer.getLongValue();
        long realLimit2 = Math.min(l, l3);
        long extractedLimit = inventory.extract((AEKey)fluidToTransfer.getKey(), realLimit2, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
        Object object4 = fluidToTransfer.getKey();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
        FluidVariant transferVariant = ((AEFluidKey)object4).toVariant();
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            double d2;
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long insertedAmount = toStorage.insert((Object)transferVariant, extractedLimit, (TransactionContext)it);
            if (insertedAmount == 0L) {
                it.abort();
                d2 = 0.0;
            } else {
                long extractedAmount = inventory.extract((AEKey)fluidToTransfer.getKey(), realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                if (extractedAmount != insertedAmount) {
                    inventory.insert((AEKey)fluidToTransfer.getKey(), realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                    it.abort();
                    d2 = 0.0;
                } else {
                    it.commit();
                    d2 = (double)extractedAmount / 81.0;
                }
            }
            d = d2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(mainThread=true)
    public final double pullFluid(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        double d;
        Predicate<FluidVariant> predicate;
        IPeripheral iPeripheral;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        if (limit.isPresent()) {
            Long l = limit.get();
            long l2 = 0L;
            if (l != null && l == l2) {
                return 0.0;
            }
        }
        if ((iPeripheral = computer.getAvailablePeripheral(fromName)) == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        Storage storage = ExtractorProxy.INSTANCE.extractFluidStorage(this.level, location.getTarget());
        if (storage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        Storage fromStorage = storage;
        if (fluidName.isEmpty()) {
            predicate = MENetworkBlockPlugin::pullFluid$lambda$14;
        } else {
            Object object = class_2378.field_11154.method_10223(new class_2960(fluidName.get()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FLUID.get(ResourceLocation(fluidName.get()))");
            class_3611 fluid = (class_3611)object;
            if (Intrinsics.areEqual((Object)fluid, (Object)class_3612.field_15906)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> MENetworkBlockPlugin.pullFluid$lambda$15(fluid, arg_0);
        }
        Predicate<FluidVariant> predicate2 = predicate;
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            double d2;
            MEStorage mEStorage;
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            ResourceAmount resourceAmount = StorageUtil.findExtractableContent((Storage)fromStorage, predicate2, (TransactionContext)((TransactionContext)it));
            if (resourceAmount == null) {
                double d3 = 0.0;
                return d3;
            }
            Intrinsics.checkNotNullExpressionValue((Object)resourceAmount, (String)"StorageUtil.findExtracta\u2026dicate, it) ?: return 0.0");
            ResourceAmount extractableResource = resourceAmount;
            IGrid iGrid = this.entity.getMainNode().getGrid();
            MEStorage mEStorage2 = mEStorage = iGrid != null && (iGrid = iGrid.getStorageService()) != null ? iGrid.getInventory() : null;
            if (mEStorage2 == null) {
                throw new LuaException("Not correctly configured AE2 Network");
            }
            Intrinsics.checkNotNullExpressionValue((Object)mEStorage2, (String)"entity.mainNode.grid?.st\u2026 configured AE2 Network\")");
            MEStorage inventory = mEStorage;
            AEFluidKey aeKey = AEFluidKey.of((FluidVariant)((FluidVariant)extractableResource.resource()));
            long l = PeripheraliumConfig.INSTANCE.getFluidStorageTransferLimit();
            Long l3 = limit.map(arg_0 -> MENetworkBlockPlugin.pullFluid$lambda$17$lambda$16(pullFluid.1.realLimit.1.INSTANCE, arg_0)).orElse(Long.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"limit.map {limit ->\n    \u2026 }.orElse(Long.MAX_VALUE)");
            long l4 = ((Number)l3).longValue();
            l = Math.min(l, l4);
            l4 = extractableResource.amount();
            long realLimit2 = Math.min(l, l4);
            long insertLimit = inventory.insert((AEKey)aeKey, realLimit2, Actionable.SIMULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
            if (insertLimit == 0L) {
                it.abort();
                d2 = 0.0;
            } else {
                long extractedAmount = fromStorage.extract(extractableResource.resource(), realLimit2, (TransactionContext)it);
                if (extractedAmount == 0L) {
                    it.abort();
                    d2 = 0.0;
                } else {
                    long insertedAmount = inventory.insert((AEKey)aeKey, realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                    if (extractedAmount != insertedAmount) {
                        inventory.extract((AEKey)aeKey, realLimit2, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)((IActionHost)this.entity)));
                        it.abort();
                        d2 = 0.0;
                    } else {
                        it.commit();
                        d2 = (double)insertedAmount / 81.0;
                    }
                }
            }
            d = d2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return d;
    }

    @LuaFunction(mainThread=true)
    public final double getEnergy() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyCapacity() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getMaxStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getAverageEnergyIncome() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getAvgPowerInjection();
    }

    @LuaFunction(mainThread=true)
    public final double getChannelEnergyDemand() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getEnergyService() : null;
        if (object == null) {
            return 0.0;
        }
        IEnergyService energyService = object;
        return energyService.getChannelPowerUsage();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<String, Object> getChannelInformation() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getPathingService() : null;
        if (object == null) {
            return MapsKt.emptyMap();
        }
        IPathingService pathingService = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"maxChannels", (Object)pathingService.getChannelMode().getAdHocNetworkChannels()), TuplesKt.to((Object)"usedChannels", (Object)pathingService.getUsedChannels())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftingCPUs() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            Map cpuInformation = new LinkedHashMap();
            if (it.getName() != null) {
                String string;
                Map map = cpuInformation;
                String string2 = "name";
                class_2561 class_25612 = it.getName();
                Intrinsics.checkNotNull((Object)class_25612);
                Intrinsics.checkNotNullExpressionValue((Object)class_25612.getString(), (String)"it.name!!.string");
                map.put(string2, string);
            }
            cpuInformation.put("capacity", 1 + it.getCoProcessors());
            cpuInformation.put("storage", it.getAvailableStorage());
            cpuInformation.put("isBusy", it.isBusy());
            data.add(cpuInformation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableItems() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableItems$lambda$19);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"craftingService.getCraftables { it is AEItemKey }");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEItemKey");
            class_1792 class_17922 = ((AEItemKey)it).getItem();
            Intrinsics.checkNotNullExpressionValue((Object)class_17922, (String)"it as AEItemKey).item");
            data.add(LuaRepresentation.INSTANCE.forItem(class_17922));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getCraftableFluids() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        List data = new ArrayList();
        Set set = craftingService.getCraftables(MENetworkBlockPlugin::getCraftableFluids$lambda$21);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"craftingService.getCraftables { it is AEFluidKey }");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AEKey it = (AEKey)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type appeng.api.stacks.AEFluidKey");
            data.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)class_2378.field_11154.method_10221((Object)((AEFluidKey)it).getFluid()).toString())));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> getPatternsFor(@NotNull String mode, @NotNull String id_key) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        ICraftingService craftingService = object;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        Collection patterns = craftingService.getCraftingFor(key);
        List data = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)patterns, (String)"patterns");
        Iterable $this$forEach$iv = patterns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericStack it;
            IPatternDetails pattern = (IPatternDetails)element$iv;
            boolean bl = false;
            Map patternRepresentation = new LinkedHashMap();
            List outputs = new ArrayList();
            List inputs = new ArrayList();
            GenericStack[] genericStackArray = pattern.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)genericStackArray, (String)"pattern.outputs");
            Object[] $this$forEach$iv2 = genericStackArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (GenericStack)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                outputs.add(AE2Helper.INSTANCE.genericStackToMap(it));
            }
            IPatternDetails.IInput[] iInputArray = pattern.getInputs();
            Intrinsics.checkNotNullExpressionValue((Object)iInputArray, (String)"pattern.inputs");
            $this$forEach$iv2 = iInputArray;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (IPatternDetails.IInput)element$iv2;
                boolean bl3 = false;
                Map inputData = null;
                if (it.getPossibleInputs().length == 1) {
                    GenericStack genericStack = it.getPossibleInputs()[0];
                    Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"it.possibleInputs[0]");
                    Map map = inputData = AE2Helper.INSTANCE.genericStackToMap(genericStack);
                    var25_25 = "count";
                    Object object2 = inputData.get("count");
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                    Long l = (long)((Integer)object2).intValue() * it.getMultiplier();
                    map.put((String)var25_25, (Object)l);
                } else {
                    List inputVariants = new ArrayList();
                    GenericStack[] genericStackArray2 = it.getPossibleInputs();
                    Intrinsics.checkNotNullExpressionValue((Object)genericStackArray2, (String)"it.possibleInputs");
                    Object[] $this$forEach$iv3 = genericStackArray2;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Map<String, Object> pInputResult;
                        GenericStack pInput = (GenericStack)element$iv3;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)pInput, (String)"pInput");
                        Map<String, Object> map = pInputResult = AE2Helper.INSTANCE.genericStackToMap(pInput);
                        String string = "count";
                        Object object3 = pInputResult.get("count");
                        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                        Long l = (long)((Integer)object3).intValue() * it.getMultiplier();
                        map.put(string, l);
                        inputVariants.add(pInputResult);
                    }
                    var25_25 = new Pair[]{TuplesKt.to((Object)"variants", (Object)inputVariants)};
                    inputData = MapsKt.mutableMapOf((Pair[])var25_25);
                }
                inputs.add(inputData);
            }
            patternRepresentation.put("inputs", inputs);
            patternRepresentation.put("outputs", outputs);
            data.add(patternRepresentation);
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getActiveCraftings() {
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"AE2 network is not connected\")");
            return methodResult;
        }
        ICraftingService craftingService = object;
        List craftingList = new ArrayList();
        ImmutableSet immutableSet = craftingService.getCpus();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CraftingJobStatus jobStatus;
            ICraftingCPU it = (ICraftingCPU)element$iv;
            boolean bl = false;
            if (!it.isBusy() || it.getJobStatus() == null) continue;
            Intrinsics.checkNotNull((Object)it.getJobStatus());
            Object object2 = new Pair[3];
            GenericStack genericStack = jobStatus.crafting();
            Intrinsics.checkNotNullExpressionValue((Object)genericStack, (String)"jobStatus.crafting");
            object2[0] = TuplesKt.to((Object)"target", AE2Helper.INSTANCE.genericStackToMap(genericStack));
            object2[1] = TuplesKt.to((Object)"amount", (Object)jobStatus.totalItems());
            object2[2] = TuplesKt.to((Object)"progress", (Object)jobStatus.progress());
            Map baseMap = MapsKt.mutableMapOf((Pair[])object2);
            if (it.getName() != null) {
                String string;
                object2 = baseMap;
                String string2 = "CPU";
                class_2561 class_25612 = it.getName();
                Intrinsics.checkNotNull((Object)class_25612);
                Intrinsics.checkNotNullExpressionValue((Object)class_25612.getString(), (String)"it.name!!.string");
                object2.put(string2, string);
            }
            craftingList.add(baseMap);
        }
        MethodResult methodResult = MethodResult.of((Object)craftingList);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(craftingList)");
        return methodResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LuaFunction(mainThread=false)
    @NotNull
    public final MethodResult scheduleCrafting(@NotNull String mode, @NotNull String id_key, @NotNull Optional<Long> amount, @NotNull Optional<String> targetCPU) {
        ICraftingCPU iCraftingCPU;
        long realAmount;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id_key, (String)"id_key");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(targetCPU, (String)"targetCPU");
        IGrid iGrid = this.entity.getMainNode().getGrid();
        Object object = iGrid != null ? iGrid.getCraftingService() : null;
        if (object == null) {
            Object[] objectArray = new Object[]{null, "AE2 network is not connected"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"AE2 network is not connected\")");
            return methodResult;
        }
        ICraftingService craftingService = object;
        AEKey key = AE2Helper.INSTANCE.buildKey(mode, id_key);
        IActionSource source = IActionSource.ofMachine((IActionHost)((IActionHost)this.entity));
        Future future = craftingService.beginCraftingCalculation(this.level, () -> MENetworkBlockPlugin.scheduleCrafting$lambda$28(source), key, realAmount = ((Number)(Intrinsics.areEqual((Object)mode, (Object)"item") ? (Number)amount.orElse(1L) : (Number)(((Number)amount.orElse(1000L)).doubleValue() * 81.0))).longValue(), CalculationStrategy.REPORT_MISSING_ITEMS);
        ICraftingPlan plan = (ICraftingPlan)future.get();
        if (!plan.missingItems().isEmpty()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = false;
            objectArray[1] = "Missing items";
            KeyCounter keyCounter = plan.missingItems();
            Intrinsics.checkNotNullExpressionValue((Object)keyCounter, (String)"plan.missingItems()");
            objectArray[2] = AE2Helper.keyCounterToLua$default(AE2Helper.INSTANCE, keyCounter, null, false, 6, null);
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(false, \"Missing items\u2026Lua(plan.missingItems()))");
            return methodResult;
        }
        if (targetCPU.isPresent()) {
            ICraftingCPU iCraftingCPU2;
            try {
                Object element$iv;
                boolean bl;
                ImmutableSet immutableSet = craftingService.getCpus();
                Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"craftingService.cpus");
                Iterable $this$first$iv = (Iterable)immutableSet;
                boolean $i$f$first = false;
                Iterator iterator = $this$first$iv.iterator();
                do {
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    element$iv = iterator.next();
                    ICraftingCPU it = (ICraftingCPU)element$iv;
                    boolean bl2 = false;
                    if (it.getName() != null) {
                        class_2561 class_25612 = it.getName();
                        Intrinsics.checkNotNull((Object)class_25612);
                        if (class_25612.getString().equals(targetCPU.get())) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                iCraftingCPU2 = (ICraftingCPU)element$iv;
            }
            catch (NoSuchElementException e) {
                Object[] objectArray = new Object[]{null, "Cannot find target CPU"};
                MethodResult methodResult = MethodResult.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find target CPU\")");
                return methodResult;
            }
            iCraftingCPU = iCraftingCPU2;
        } else {
            iCraftingCPU = null;
        }
        ICraftingCPU realTargetCPU = iCraftingCPU;
        craftingService.submitJob(plan, null, realTargetCPU, false, source);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType((IPeripheralPlugin)this);
    }

    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral((IPeripheralPlugin)this);
    }

    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral((IPeripheralPlugin)this, (IPluggablePeripheral)value);
    }

    @NotNull
    public List<BoundMethod> getMethods() {
        return IPeripheralPlugin.DefaultImpls.getMethods((IPeripheralPlugin)this);
    }

    @NotNull
    public IPeripheralOperation<?>[] getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations((IPeripheralPlugin)this);
    }

    private static final boolean items$lambda$0(AEKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AEItemKey;
    }

    private static final boolean pushItem$lambda$1(AEItemKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushItem$lambda$2(class_1792 $item, AEItemKey it) {
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getItem(), (Object)$item);
    }

    private static final boolean pullItem$lambda$5(ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullItem$lambda$6(class_1792 $item, ItemVariant it) {
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isOf((Object)$item);
    }

    private static final boolean tanks$lambda$8(AEKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AEFluidKey;
    }

    private static final boolean pushFluid$lambda$9(AEFluidKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushFluid$lambda$10(class_3611 $fluid, AEFluidKey it) {
        Intrinsics.checkNotNullParameter((Object)$fluid, (String)"$fluid");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().method_15780($fluid);
    }

    private static final Long pushFluid$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    private static final boolean pullFluid$lambda$14(FluidVariant it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullFluid$lambda$15(class_3611 $fluid, FluidVariant it) {
        Intrinsics.checkNotNullParameter((Object)$fluid, (String)"$fluid");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isOf((Object)$fluid);
    }

    private static final Long pullFluid$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0);
    }

    private static final boolean getCraftableItems$lambda$19(AEKey it) {
        return it instanceof AEItemKey;
    }

    private static final boolean getCraftableFluids$lambda$21(AEKey it) {
        return it instanceof AEFluidKey;
    }

    private static final IActionSource scheduleCrafting$lambda$28(IActionSource $source) {
        return $source;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Companion;", "", "", "PLUGIN_TYPE", "Ljava/lang/String;", "<init>", "()V", "peripheralworks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralworks/integrations/ae2/MENetworkBlockPlugin$Provider;", "Lsite/siredvin/peripheralworks/api/PeripheralPluginProvider;", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2350;", "side", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "provide", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "", "", "getConflictWith", "()Ljava/util/Set;", "conflictWith", "getPluginType", "()Ljava/lang/String;", "pluginType", "", "getPriority", "()I", "priority", "<init>", "()V", "peripheralworks"})
    public static final class Provider
    implements PeripheralPluginProvider {
        @Override
        @NotNull
        public String getPluginType() {
            return MENetworkBlockPlugin.PLUGIN_TYPE;
        }

        @Override
        @NotNull
        public Set<String> getConflictWith() {
            Object[] objectArray = new String[]{"item_storage", "fluid_storage"};
            return SetsKt.setOf((Object[])objectArray);
        }

        @Override
        public int getPriority() {
            return 1000;
        }

        @Override
        @Nullable
        public IPeripheralPlugin provide(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2350 side) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (!Configuration.INSTANCE.getEnableMEInterface()) {
                return null;
            }
            class_2586 entity = level.method_8321(pos);
            if (!(entity instanceof AENetworkBlockEntity)) {
                return null;
            }
            return new MENetworkBlockPlugin(level, (AENetworkBlockEntity)entity);
        }

        @Override
        public int compareTo(@NotNull PeripheralPluginProvider other) {
            return PeripheralPluginProvider.DefaultImpls.compareTo(this, other);
        }
    }
}

