/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.component.config;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.impl.codec.EnumMapCodec;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.apache.logging.log4j.util.TriConsumer;

public class SideConfig {
    private final Map<RelativeSide, SideMode> sides = new HashMap<RelativeSide, SideMode>();
    private final ISideConfigComponent component;
    private boolean autoInput;
    private boolean autoOutput;
    private final boolean enabled;
    private TriConsumer<RelativeSide, SideMode, SideMode> callback;

    public SideConfig(ISideConfigComponent component, Map<RelativeSide, SideMode> defaultConfig, boolean autoInput, boolean autoOutput, boolean enabled) {
        this.component = component;
        this.sides.putAll(defaultConfig);
        this.autoInput = autoInput;
        this.autoOutput = autoOutput;
        this.enabled = enabled;
    }

    private class_2350 facing() {
        return (class_2350)this.component.getManager().getTile().method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public ISideConfigComponent getComponent() {
        return this.component;
    }

    public SideMode getSideMode(RelativeSide side) {
        return this.sides.get((Object)side);
    }

    public SideMode getSideMode(class_2350 direction) {
        return this.getSideMode(RelativeSide.fromDirections(this.facing(), direction));
    }

    public void setSideMode(RelativeSide side, SideMode mode) {
        SideMode oldMode = this.sides.put(side, mode);
        if (this.callback != null && !this.getComponent().getManager().getLevel().method_8608()) {
            this.callback.accept((Object)side, (Object)oldMode, (Object)mode);
        }
    }

    public boolean isAutoInput() {
        return this.autoInput;
    }

    public boolean isAutoOutput() {
        return this.autoOutput;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAutoInput(boolean autoInput) {
        this.autoInput = autoInput;
    }

    public void setAutoOutput(boolean autoOutput) {
        this.autoOutput = autoOutput;
    }

    public void set(SideConfig config) {
        for (RelativeSide side : RelativeSide.values()) {
            this.setSideMode(side, config.getSideMode(side));
        }
        this.setAutoInput(config.isAutoInput());
        this.setAutoOutput(config.isAutoOutput());
    }

    public void setCallback(TriConsumer<RelativeSide, SideMode, SideMode> callback) {
        this.callback = callback;
    }

    public SideConfig copy() {
        return new SideConfig(this.component, this.sides, this.autoInput, this.autoOutput, this.enabled);
    }

    public class_2520 serialize() {
        class_2487 nbt = new class_2487();
        this.sides.forEach((side, mode) -> nbt.method_10566(side.name(), (class_2520)class_2481.method_23233((byte)((byte)mode.ordinal()))));
        nbt.method_10556("input", this.autoInput);
        nbt.method_10556("output", this.autoOutput);
        return nbt;
    }

    public void deserialize(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 nbt = (class_2487)tag;
            for (RelativeSide side : RelativeSide.values()) {
                class_2520 class_25202 = nbt.method_10580(side.name());
                if (!(class_25202 instanceof class_2481)) continue;
                class_2481 byteTag = (class_2481)class_25202;
                this.sides.put(side, SideMode.values()[byteTag.method_10701()]);
            }
            this.autoInput = nbt.method_10577("input");
            this.autoOutput = nbt.method_10577("output");
        }
    }

    public static class Template {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(EnumMapCodec.of(RelativeSide.class, SideMode.CODEC, SideMode.BOTH).forGetter(template -> template.sides), NamedCodec.BOOL.optionalFieldOf("input", false).forGetter(template -> template.autoInput), NamedCodec.BOOL.optionalFieldOf("output", false).forGetter(template -> template.autoOutput), NamedCodec.BOOL.optionalFieldOf("enabled", true).forGetter(template -> template.enabled)).apply((Applicative)templateInstance, Template::new), "Side Config Template");
        public static final Template DEFAULT_ALL_BOTH = Template.makeDefault(SideMode.BOTH);
        public static final Template DEFAULT_ALL_INPUT = Template.makeDefault(SideMode.INPUT);
        public static final Template DEFAULT_ALL_OUTPUT = Template.makeDefault(SideMode.OUTPUT);
        public static final Template DEFAULT_ALL_NONE = Template.makeDefault(SideMode.NONE);
        private final Map<RelativeSide, SideMode> sides;
        private final boolean autoInput;
        private final boolean autoOutput;
        private final boolean enabled;

        private static Template makeDefault(SideMode defaultMode) {
            EnumMap map = Maps.newEnumMap(RelativeSide.class);
            for (RelativeSide side : RelativeSide.values()) {
                map.put(side, defaultMode);
            }
            return new Template(map, false, false, true);
        }

        private Template(Map<RelativeSide, SideMode> sides, boolean autoInput, boolean autoOutput, boolean enabled) {
            this.sides = sides;
            this.autoInput = autoInput;
            this.autoOutput = autoOutput;
            this.enabled = enabled;
        }

        public <T extends ISideConfigComponent> SideConfig build(T component) {
            return new SideConfig(component, this.sides, this.autoInput, this.autoOutput, this.enabled);
        }
    }
}

