/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class DefaultCodecs {
    public static final NamedCodec<class_2960> RESOURCE_LOCATION = NamedCodec.STRING.comapFlatMap(DefaultCodecs::decodeResourceLocation, class_2960::toString, "Resource location");
    public static final NamedCodec<Character> CHARACTER = NamedCodec.STRING.comapFlatMap(DefaultCodecs::decodeCharacter, Object::toString, "Character");
    public static final NamedCodec<class_2487> NBT_FROM_STRING = NamedCodec.STRING.comapFlatMap(DefaultCodecs::decodeNbtFromString, class_2487::toString, "NBT from String");
    public static final NamedCodec<class_2487> NBT_FROM_JSON = NamedCodec.of(class_2487.field_25128, "NBT from JSON");
    public static final NamedCodec<class_2487> COMPOUND_TAG = NamedCodec.either(NBT_FROM_STRING, NBT_FROM_JSON, "Compound nbt").xmap(either -> (class_2487)either.map(Function.identity(), Function.identity()), Either::left, "Compound nbt");
    public static final NamedCodec<class_3414> SOUND_EVENT = RESOURCE_LOCATION.xmap(class_3414::new, class_3414::method_14833, "Sound event");
    public static final NamedCodec<class_2350> DIRECTION = NamedCodec.enumCodec(class_2350.class);
    public static final NamedCodec<class_1799> ITEM_STACK = NamedCodec.record(itemStackInstance -> itemStackInstance.group(RegistrarCodec.ITEM.fieldOf("id").forGetter(class_1799::method_7909), NamedCodec.INT.optionalFieldOf("Count", 1).forGetter(class_1799::method_7947), COMPOUND_TAG.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.method_7969()))).apply((Applicative)itemStackInstance, (item, count, nbt) -> {
        class_1799 stack = item.method_7854();
        stack.method_7939(count.intValue());
        nbt.ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
        return stack;
    }), "Item stack");
    public static final NamedCodec<class_1799> ITEM_OR_STACK = NamedCodec.either(RegistrarCodec.ITEM, ITEM_STACK).xmap(either -> (class_1799)either.map(class_1792::method_7854, Function.identity()), Either::right, "Item Stack");

    public static <T> NamedCodec<class_6862<T>> tagKey(class_5321<class_2378<T>> registry) {
        return RESOURCE_LOCATION.xmap(rl -> class_6862.method_40092((class_5321)registry, (class_2960)rl), class_6862::comp_327, "Tag: " + registry.method_29177());
    }

    private static DataResult<class_2960> decodeResourceLocation(String encoded) {
        try {
            return DataResult.success((Object)new class_2960(encoded));
        }
        catch (class_151 e) {
            return DataResult.error((String)e.getMessage());
        }
    }

    private static DataResult<Character> decodeCharacter(String encoded) {
        if (encoded.length() != 1) {
            return DataResult.error((String)("Invalid character : \"" + encoded + "\" must be a single character !"));
        }
        return DataResult.success((Object)Character.valueOf(encoded.charAt(0)));
    }

    private static DataResult<class_2487> decodeNbtFromString(String encoded) {
        class_2522 parser = new class_2522(new StringReader(encoded));
        try {
            return DataResult.success((Object)parser.method_10727());
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)e.getMessage());
        }
    }
}

