/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.util.Utils;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class ItemSlot
extends SnapshotParticipant<class_1799>
implements SingleSlotStorage<ItemVariant> {
    private final ItemMachineComponent component;
    @Nullable
    private final class_2350 side;

    public ItemSlot(ItemMachineComponent component, @Nullable class_2350 side) {
        this.component = component;
        this.side = side;
    }

    public ItemMachineComponent getComponent() {
        return this.component;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isInput()) {
            return 0L;
        }
        long inserted = this.component.insert(resource.getItem(), Utils.toInt(maxAmount), resource.getNbt(), true);
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.component.insert(resource.getItem(), Utils.toInt(maxAmount), resource.getNbt(), false);
            return inserted;
        }
        return 0L;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isOutput()) {
            return 0L;
        }
        if (this.component.getItemStack().method_7909() != resource.getItem() || !class_1799.method_7975((class_1799)this.component.getItemStack(), (class_1799)resource.toStack())) {
            return 0L;
        }
        long extracted = this.component.extract(Utils.toInt(maxAmount), true).method_7947();
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.component.extract(Utils.toInt(maxAmount), false);
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.component.getItemStack().method_7960();
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.component.getItemStack());
    }

    public long getAmount() {
        return this.component.getItemStack().method_7947();
    }

    public long getCapacity() {
        return this.component.getCapacity();
    }

    protected class_1799 createSnapshot() {
        return this.component.getItemStack().method_7972();
    }

    protected void readSnapshot(class_1799 snapshot) {
        this.component.setItemStack(snapshot);
    }

    protected void onFinalCommit() {
        this.component.getManager().markDirty();
    }
}

