/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class FluidTank
extends SnapshotParticipant<FluidStack>
implements SingleSlotStorage<FluidVariant> {
    private final FluidMachineComponent component;
    @Nullable
    private final class_2350 side;

    public FluidTank(FluidMachineComponent component, @Nullable class_2350 side) {
        this.component = component;
        this.side = side;
    }

    public FluidMachineComponent getComponent() {
        return this.component;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isInput()) {
            return 0L;
        }
        if (!this.component.isFluidValid(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)maxAmount))) {
            return 0L;
        }
        long inserted = this.component.insert(resource.getFluid(), maxAmount, resource.getNbt(), true);
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.component.insert(resource.getFluid(), maxAmount, resource.getNbt(), false);
            return inserted;
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side != null && !this.component.getConfig().getSideMode(this.side).isOutput()) {
            return 0L;
        }
        if (this.component.getFluidStack().getFluid() != resource.getFluid() || !this.component.getFluidStack().isTagEqual(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)maxAmount))) {
            return 0L;
        }
        long extracted = this.component.extract(maxAmount, true).getAmount();
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.component.extract(maxAmount, false);
            return extracted;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.component.getFluidStack().isEmpty();
    }

    public FluidVariant getResource() {
        return FluidStackHooksFabric.toFabric((FluidStack)this.component.getFluidStack());
    }

    public long getAmount() {
        return this.component.getFluidStack().getAmount();
    }

    public long getCapacity() {
        return this.component.getCapacity();
    }

    protected FluidStack createSnapshot() {
        return this.component.getFluidStack().copy();
    }

    protected void readSnapshot(FluidStack snapshot) {
        this.component.setFluidStack(snapshot);
    }

    protected void onFinalCommit() {
        this.component.getManager().markDirty();
    }
}

