/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.util.transfer.ICommonItemHandler;
import fr.frinn.custommachinery.fabric.transfer.ItemSlot;
import fr.frinn.custommachinery.fabric.transfer.SidedItemStorage;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricItemHandler
implements ICommonItemHandler {
    private final ItemComponentHandler handler;
    private final Map<class_2350, SidedItemStorage> sidedStorages = Maps.newEnumMap(class_2350.class);
    private final Map<class_2350, BlockApiCache<Storage<ItemVariant>, class_2350>> neighbourStorages = Maps.newEnumMap(class_2350.class);

    public FabricItemHandler(ItemComponentHandler handler) {
        this.handler = handler;
        for (class_2350 side : class_2350.values()) {
            this.sidedStorages.put(side, new SidedItemStorage(handler, side));
        }
    }

    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        return (Storage)this.sidedStorages.get(side);
    }

    @Override
    public void configChanged(RelativeSide side, SideMode oldMode, SideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.handler.getManager().getLevel().method_8452(this.handler.getManager().getTile().method_11016(), this.handler.getManager().getTile().method_11010().method_26204());
        }
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void tick() {
        for (class_2350 side : class_2350.values()) {
            Storage neighbour;
            if (this.handler.getComponents().stream().allMatch(component -> component.getConfig().getSideMode(side) == SideMode.NONE)) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockApiCache<Storage<ItemVariant>, class_2350>)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.handler.getManager().getLevel()), (class_2338)this.handler.getManager().getTile().method_11016().method_10093(side)));
            }
            if ((neighbour = (Storage)this.neighbourStorages.get(side).find((Object)side.method_10153())) == null) continue;
            for (ItemSlot tank : this.sidedStorages.get((Object)side).parts) {
                if (tank.getComponent().getConfig().isAutoInput() && tank.getComponent().getConfig().getSideMode(side).isInput() && tank.getAmount() < tank.getCapacity()) {
                    StorageUtil.move((Storage)neighbour, (Storage)tank, fluid -> true, (long)Long.MAX_VALUE, null);
                }
                if (!tank.getComponent().getConfig().isAutoOutput() || !tank.getComponent().getConfig().getSideMode(side).isOutput() || tank.getAmount() <= 0L) continue;
                StorageUtil.move((Storage)((Storage)this.sidedStorages.get(side)), (Storage)neighbour, fluid -> true, (long)Long.MAX_VALUE, null);
            }
        }
    }
}

