/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.util.transfer.ICommonFluidHandler;
import fr.frinn.custommachinery.fabric.transfer.FluidTank;
import fr.frinn.custommachinery.fabric.transfer.SidedFluidStorage;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricFluidHandler
implements ICommonFluidHandler {
    private final FluidComponentHandler fluidHandler;
    private final Storage<FluidVariant> generalTank;
    private final Map<class_2350, SidedFluidStorage> sidedTanks = Maps.newEnumMap(class_2350.class);
    private final Map<class_2350, BlockApiCache<Storage<FluidVariant>, class_2350>> neighbourStorages = Maps.newEnumMap(class_2350.class);

    public FabricFluidHandler(FluidComponentHandler fluidHandler) {
        this.fluidHandler = fluidHandler;
        this.generalTank = new SidedFluidStorage(fluidHandler, null);
        for (class_2350 side : class_2350.values()) {
            this.sidedTanks.put(side, new SidedFluidStorage(fluidHandler, side));
        }
    }

    @Override
    public void configChanged(RelativeSide side, SideMode oldMode, SideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.fluidHandler.getManager().getLevel().method_8452(this.fluidHandler.getManager().getTile().method_11016(), this.fluidHandler.getManager().getTile().method_11010().method_26204());
        }
    }

    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        return (Storage)this.sidedTanks.get(side);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void tick() {
        for (class_2350 side : class_2350.values()) {
            Storage neighbour;
            if (this.fluidHandler.getComponents().stream().allMatch(component -> component.getConfig().getSideMode(side) == SideMode.NONE)) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockApiCache<Storage<FluidVariant>, class_2350>)BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)this.fluidHandler.getManager().getLevel()), (class_2338)this.fluidHandler.getManager().getTile().method_11016().method_10093(side)));
            }
            if ((neighbour = (Storage)this.neighbourStorages.get(side).find((Object)side.method_10153())) == null) continue;
            for (FluidTank tank : this.sidedTanks.get((Object)side).parts) {
                if (tank.getComponent().getConfig().isAutoInput() && tank.getComponent().getConfig().getSideMode(side).isInput() && tank.getAmount() < tank.getCapacity()) {
                    StorageUtil.move((Storage)neighbour, (Storage)tank, fluid -> true, (long)Long.MAX_VALUE, null);
                }
                if (!tank.getComponent().getConfig().isAutoOutput() || !tank.getComponent().getConfig().getSideMode(side).isOutput() || tank.getAmount() <= 0L) continue;
                StorageUtil.move((Storage)((Storage)this.sidedTanks.get(side)), (Storage)neighbour, fluid -> true, (long)Long.MAX_VALUE, null);
            }
        }
    }

    @Override
    public boolean interactWithFluidHandler(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960()) {
            return false;
        }
        Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (storage == null) {
            return false;
        }
        long filled = StorageUtil.move((Storage)storage, this.generalTank, fluid -> true, (long)Long.MAX_VALUE, null);
        if (filled > 0L) {
            return true;
        }
        return StorageUtil.move(this.generalTank, (Storage)storage, fluid -> true, (long)Long.MAX_VALUE, null) > 0L;
    }
}

