/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.fabric.transfer;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.util.transfer.ICommonEnergyHandler;
import fr.frinn.custommachinery.fabric.transfer.EnergyBuffer;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class FabricEnergyHandler
implements ICommonEnergyHandler {
    private final EnergyMachineComponent component;
    private final Map<class_2350, EnergyStorage> sidedStorages = Maps.newEnumMap(class_2350.class);
    private final Map<class_2350, BlockApiCache<EnergyStorage, class_2350>> neighbourStorages = Maps.newEnumMap(class_2350.class);

    public FabricEnergyHandler(EnergyMachineComponent component) {
        this.component = component;
        for (class_2350 side : class_2350.values()) {
            this.sidedStorages.put(side, new EnergyBuffer(component, side));
        }
    }

    public EnergyStorage getStorage(class_2350 side) {
        return this.sidedStorages.get(side);
    }

    @Override
    public void configChanged(RelativeSide side, SideMode oldMode, SideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.component.getManager().getLevel().method_8452(this.component.getManager().getTile().method_11016(), this.component.getManager().getTile().method_11010().method_26204());
        }
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void tick() {
        for (class_2350 side : class_2350.values()) {
            EnergyStorage neighbour;
            if (this.component.getConfig().getSideMode(side) == SideMode.NONE) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockApiCache<EnergyStorage, class_2350>)BlockApiCache.create((BlockApiLookup)EnergyStorage.SIDED, (class_3218)((class_3218)this.component.getManager().getLevel()), (class_2338)this.component.getManager().getTile().method_11016().method_10093(side)));
            }
            if ((neighbour = (EnergyStorage)this.neighbourStorages.get(side).find((Object)side.method_10153())) == null) continue;
            if (this.component.getConfig().isAutoInput() && this.component.getConfig().getSideMode(side).isInput() && this.component.getEnergy() < this.component.getCapacity()) {
                EnergyStorageUtil.move((EnergyStorage)neighbour, (EnergyStorage)this.sidedStorages.get(side), (long)Long.MAX_VALUE, null);
            }
            if (!this.component.getConfig().isAutoOutput() || !this.component.getConfig().getSideMode(side).isOutput() || this.component.getEnergy() <= 0L) continue;
            EnergyStorageUtil.move((EnergyStorage)this.sidedStorages.get(side), (EnergyStorage)neighbour, (long)Long.MAX_VALUE, null);
        }
    }
}

