/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.BlockTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

public interface IIngredient<O>
extends Predicate<O> {
    public static final NamedCodec<IIngredient<class_1792>> ITEM = new NamedCodec<IIngredient<class_1792>>(){

        @Override
        public <T> DataResult<Pair<IIngredient<class_1792>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult mapResult = ops.getMap(input);
            if (mapResult.result().isPresent()) {
                MapLike map = (MapLike)mapResult.result().get();
                Object item = map.get("item");
                if (item != null) {
                    return RegistrarCodec.ITEM.read(ops, item).map(i -> Pair.of((Object)new ItemIngredient((class_1792)i), (Object)ops.empty()));
                }
                Object tag = map.get("tag");
                if (tag != null) {
                    return DefaultCodecs.tagKey(class_2378.field_25108).read(ops, tag).map(t -> Pair.of((Object)ItemTagIngredient.create((class_6862<class_1792>)t), (Object)ops.empty()));
                }
                return DataResult.error((String)("Couldn't get an item ingredient from: " + map));
            }
            DataResult result = ops.getStringValue(input);
            if (result.result().isPresent()) {
                String s = (String)result.result().get();
                if (s.startsWith("#")) {
                    try {
                        return DataResult.success((Object)Pair.of((Object)ItemTagIngredient.create(s), (Object)ops.empty()));
                    }
                    catch (IllegalArgumentException e) {
                        return DataResult.error((String)e.getMessage());
                    }
                }
                try {
                    return DataResult.success((Object)Pair.of((Object)new ItemIngredient((class_1792)class_2378.field_11142.method_10223(new class_2960(s))), (Object)ops.empty()));
                }
                catch (class_151 e) {
                    return DataResult.error((String)("Invalid item ID: " + e.getMessage()));
                }
            }
            return DataResult.error((String)("Unable to get an item ingredient from: " + input));
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, IIngredient<class_1792> input, T prefix) {
            if (input instanceof ItemIngredient) {
                ItemIngredient ingredient = (ItemIngredient)input;
                return ops.mergeToPrimitive(prefix, ops.createString(ingredient.toString()));
            }
            if (input instanceof ItemTagIngredient) {
                ItemTagIngredient ingredient = (ItemTagIngredient)input;
                return ops.mergeToPrimitive(prefix, ops.createString(ingredient.toString()));
            }
            return DataResult.error((String)String.format("Item Ingredient: %s is not an item nor a tag !", input));
        }

        @Override
        public String name() {
            return "Item ingredient";
        }
    };
    public static final NamedCodec<IIngredient<class_3611>> FLUID = NamedCodec.either(FluidIngredient.CODEC, FluidTagIngredient.CODEC, "Fluid Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof FluidIngredient) {
            return DataResult.success((Object)Either.left((Object)((FluidIngredient)ingredient)));
        }
        if (ingredient instanceof FluidTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((FluidTagIngredient)ingredient)));
        }
        return DataResult.error((String)String.format("Fluid Ingredient : %s is not a fluid nor a tag !", ingredient));
    }, "Fluid ingredient");
    public static final NamedCodec<IIngredient<PartialBlockState>> BLOCK = NamedCodec.either(BlockIngredient.CODEC, BlockTagIngredient.CODEC, "Block Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof BlockIngredient) {
            return DataResult.success((Object)Either.left((Object)((BlockIngredient)ingredient)));
        }
        if (ingredient instanceof BlockTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((BlockTagIngredient)ingredient)));
        }
        return DataResult.error((String)String.format("Block Ingredient : %s is not a block nor a tag !", ingredient));
    }, "Block ingredient");

    public List<O> getAll();
}

