/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final Random RAND = new Random();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,###");

    public static boolean canPlayerManageMachines(class_1657 player) {
        return player.method_5687(Objects.requireNonNull(player.method_5682()).method_3798());
    }

    public static class_243 vec3dFromBlockPos(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static boolean testNBT(class_2487 nbt, @Nullable class_2487 tested) {
        if (tested == null) {
            return false;
        }
        for (String key : tested.method_10541()) {
            if (nbt.method_10545(key) && nbt.method_10540(key) == tested.method_10540(key) && Utils.testINBT(nbt.method_10580(key), tested.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    public static <T extends class_2520> boolean testINBT(@Nullable T inbt, @Nullable T tested) {
        if (inbt == null || tested == null) {
            return false;
        }
        return switch (inbt.method_10711()) {
            case 1 -> {
                if (((class_2481)inbt).method_10698() == ((class_2481)tested).method_10698()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((class_2516)inbt).method_10696() == ((class_2516)tested).method_10696()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (((class_2497)inbt).method_10701() == ((class_2497)tested).method_10701()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (((class_2503)inbt).method_10699() == ((class_2503)tested).method_10699()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (((class_2494)inbt).method_10700() == ((class_2494)tested).method_10700()) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (((class_2489)inbt).method_10697() == ((class_2489)tested).method_10697()) {
                    yield true;
                }
                yield false;
            }
            case 7 -> ((class_2479)inbt).containsAll((Collection)((class_2479)tested));
            case 8 -> inbt.method_10714().equals(tested.method_10714());
            case 9 -> ((class_2499)inbt).containsAll((Collection)((class_2499)tested));
            case 10 -> Utils.testNBT((class_2487)inbt, (class_2487)tested);
            case 11 -> ((class_2495)inbt).containsAll((Collection)((class_2495)tested));
            case 12 -> ((class_2501)inbt).containsAll((Collection)((class_2501)tested));
            case 99 -> ((class_2514)inbt).method_10702().equals(((class_2514)tested).method_10702());
            default -> false;
        };
    }

    public static class_238 rotateBox(class_238 box, class_2350 to) {
        return switch (to) {
            case class_2350.field_11034 -> new class_238(box.field_1321, box.field_1322, -box.field_1323, box.field_1324, box.field_1325, -box.field_1320);
            case class_2350.field_11043 -> new class_238(-box.field_1323, box.field_1322, -box.field_1321, -box.field_1320, box.field_1325, -box.field_1324);
            case class_2350.field_11039 -> new class_238(-box.field_1321, box.field_1322, box.field_1323, -box.field_1324, box.field_1325, box.field_1320);
            default -> new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
        };
    }

    public static boolean isResourceNameValid(String resourceLocation) {
        try {
            class_2960 location = new class_2960(resourceLocation);
            return true;
        }
        catch (class_151 e) {
            return false;
        }
    }

    public static float getMachineBreakSpeed(MachineAppearance appearance, class_1922 world, class_2338 pos, class_1657 player) {
        float hardness = appearance.getHardness();
        if (hardness <= 0.0f) {
            return 0.0f;
        }
        float digSpeed = player.method_7351((class_2680)MachineBlockState.CACHE.getUnchecked((Object)appearance));
        float canHarvest = player.method_7305((class_2680)MachineBlockState.CACHE.getUnchecked((Object)appearance)) ? 30.0f : 100.0f;
        return digSpeed / hardness / canHarvest;
    }

    public static class_1799 makeItemStack(class_1792 item, int amount, @Nullable class_2487 nbt) {
        class_1799 stack = new class_1799((class_1935)item, amount);
        stack.method_7980(nbt == null ? null : nbt.method_10553());
        return stack;
    }

    public static int toInt(long l) {
        try {
            return Math.toIntExact(l);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> p_152133_, class_2591<E> p_152134_, class_5558<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static String format(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(double number) {
        return NUMBER_FORMAT.format(number);
    }
}

