/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5251;

public class TextComponentUtils {
    public static final NamedCodec<class_5251> COLOR_CODEC = NamedCodec.STRING.comapFlatMap(encoded -> {
        class_5251 color = class_5251.method_27719((String)encoded);
        if (color != null) {
            return DataResult.success((Object)color);
        }
        return DataResult.error((String)("Invalid color: " + encoded));
    }, class_5251::method_27721, "Text color");
    public static final NamedMapCodec<class_2583> STYLE_CODEC = NamedCodec.record(styleInstance -> styleInstance.group(NamedCodec.BOOL.optionalFieldOf("bold", false).forGetter(class_2583::method_10984), NamedCodec.BOOL.optionalFieldOf("italic", false).forGetter(class_2583::method_10966), NamedCodec.BOOL.optionalFieldOf("underlined", false).forGetter(class_2583::method_10965), NamedCodec.BOOL.optionalFieldOf("strikethrough", false).forGetter(class_2583::method_10986), NamedCodec.BOOL.optionalFieldOf("obfuscated", false).forGetter(class_2583::method_10987), COLOR_CODEC.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.method_10973())), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("font", new class_2960("default")).forGetter(class_2583::method_27708)).apply((Applicative)styleInstance, (bold, italic, underlined, strikethrough, obfuscated, color, font) -> class_2583.field_24360.method_10982(bold).method_10978(italic).method_30938(underlined).method_36140(strikethrough).method_36141(obfuscated).method_27703((class_5251)color.orElse(null)).method_27704(font)), "Style");
    public static final NamedCodec<class_2561> TEXT_COMPONENT_CODEC = NamedCodec.record(iTextComponentInstance -> iTextComponentInstance.group(NamedCodec.STRING.fieldOf("text").forGetter(iTextComponent -> iTextComponent instanceof class_2588 ? ((class_2588)iTextComponent).method_11022() : iTextComponent.method_10851()), STYLE_CODEC.forGetter(class_2561::method_10866), NamedCodec.lazy(TextComponentUtils::getCodec, "Text component").listOf().optionalFieldOf("childrens", Collections.emptyList()).forGetter(class_2561::method_10855)).apply((Applicative)iTextComponentInstance, (text, style, childrens) -> {
        class_2588 component = new class_2588(text);
        component.method_10862(style);
        childrens.forEach(arg_0 -> ((class_2588)component).method_10852(arg_0));
        return component;
    }), "Text component");
    public static final NamedCodec<class_2561> CODEC = NamedCodec.either(TEXT_COMPONENT_CODEC, NamedCodec.STRING).xmap(either -> (class_2561)either.map(Function.identity(), class_2588::new), Either::left, "Text component");

    public static String toJsonString(class_2561 component) {
        DataResult result = TEXT_COMPONENT_CODEC.encodeStart(JsonOps.INSTANCE, component);
        return result.result().map(JsonElement::toString).orElse("");
    }

    public static class_2561 fromJsonString(String jsonString) {
        JsonElement json = JsonParser.parseString((String)jsonString);
        return TEXT_COMPONENT_CODEC.decode(JsonOps.INSTANCE, json).result().map(Pair::getFirst).orElse(class_2585.field_24366);
    }

    private static NamedCodec<class_2561> getCodec() {
        return TEXT_COMPONENT_CODEC;
    }
}

