/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.util.IMachineModelLocation;
import net.minecraft.class_151;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MachineModelLocation
implements IMachineModelLocation {
    public static final NamedCodec<MachineModelLocation> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)MachineModelLocation.of(s));
        }
        catch (class_151 e) {
            return DataResult.error((String)e.getMessage());
        }
    }, MachineModelLocation::toString, "Model location");
    private final String loc;
    @Nullable
    private final class_2680 state;
    @Nullable
    private final class_2960 id;
    @Nullable
    private final String properties;

    public static MachineModelLocation of(String loc) {
        if (loc.contains("#")) {
            return new MachineModelLocation(loc, null, new class_2960(loc.substring(0, loc.indexOf("#"))), loc.substring(loc.indexOf("#") + 1));
        }
        try {
            return new MachineModelLocation(loc, new class_2259(new StringReader(loc), false).method_9678(false).method_9669(), null, null);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return new MachineModelLocation(loc, null, new class_2960(loc), null);
        }
    }

    private MachineModelLocation(String loc, @Nullable class_2680 state, @Nullable class_2960 id, @Nullable String properties) {
        this.loc = loc;
        this.state = state;
        this.id = id;
        this.properties = properties;
    }

    @Override
    @Nullable
    public class_2680 getState() {
        return this.state;
    }

    @Override
    @Nullable
    public class_2960 getLoc() {
        return this.id;
    }

    @Override
    @Nullable
    public String getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return this.loc;
    }
}

