/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import dev.architectury.event.events.common.TickEvent;
import fr.frinn.custommachinery.api.machine.MachineTile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class MachineList {
    private static final List<WeakReference<MachineTile>> LOADED_MACHINES = Collections.synchronizedList(new ArrayList());
    private static boolean needRefresh = false;

    public static synchronized void addMachine(MachineTile tile) {
        if (tile.method_10997() != null && !tile.method_10997().method_8608()) {
            LOADED_MACHINES.add(new WeakReference<MachineTile>(tile));
        }
    }

    public static synchronized void refreshAllMachines() {
        Iterator<WeakReference<MachineTile>> iterator = LOADED_MACHINES.iterator();
        while (iterator.hasNext()) {
            MachineTile tile = (MachineTile)((Object)iterator.next().get());
            if (tile != null) {
                tile.refreshMachine(null);
                continue;
            }
            iterator.remove();
        }
    }

    public static void setNeedRefresh() {
        needRefresh = true;
    }

    private static void serverTick(MinecraftServer server) {
        if (needRefresh) {
            needRefresh = false;
            MachineList.refreshAllMachines();
        }
    }

    static {
        TickEvent.ServerLevelTick.SERVER_POST.register(MachineList::serverTick);
    }
}

