/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_85;
import net.minecraft.class_91;
import net.minecraft.server.MinecraftServer;

public class LootTableHelper {
    private static final List<class_2960> tables = new ArrayList<class_2960>();
    private static Map<class_2960, List<Pair<class_1799, Double>>> lootsMap = new HashMap<class_2960, List<Pair<class_1799, Double>>>();

    public static void addTable(class_2960 table) {
        if (!tables.contains(table)) {
            tables.add(table);
        }
    }

    public static void generate(MinecraftServer server) {
        lootsMap.clear();
        class_47 context = new class_47.class_48(server.method_30002()).method_309(Registration.CUSTOM_MACHINE_LOOT_PARAMETER_SET);
        for (class_2960 table : tables) {
            List<Pair<class_1799, Double>> loots = LootTableHelper.getLoots(table, server, context);
            lootsMap.put(table, loots);
        }
    }

    private static List<Pair<class_1799, Double>> getLoots(class_2960 table, MinecraftServer server, class_47 context) {
        ArrayList<Pair<class_1799, Double>> loots = new ArrayList<Pair<class_1799, Double>>();
        class_52 lootTable = server.method_3857().method_367(table);
        BiFunction globalFunction = lootTable.field_945;
        List<class_55> pools = PlatformHelper.getPoolsFromTable(lootTable);
        if (pools == null) {
            return Collections.emptyList();
        }
        for (class_55 pool : pools) {
            class_79[] entries = pool.field_953;
            float total = Arrays.stream(entries).filter(entry -> entry instanceof class_85).mapToInt(entry -> ((class_85)entry).field_995).sum();
            Arrays.stream(entries).filter(entry -> entry instanceof class_77).map(entry -> (class_77)entry).forEach(entry -> {
                Consumer<class_1799> consumer = stack -> loots.add(Pair.of((Object)stack, (Object)((float)entry.field_995 / total)));
                consumer = LootTableHelper.applyFunctions(consumer, entry.field_996, globalFunction, context);
                entry.method_433(consumer, context);
            });
            Arrays.stream(entries).filter(entry -> entry instanceof class_91).map(entry -> (class_91)entry).forEach(entry -> {
                Consumer<class_1799> consumer = stack -> loots.add(Pair.of((Object)stack, (Object)((float)entry.field_995 / total / (float)(entry.field_1006 ? TagUtil.getItems((class_6862<class_1792>)entry.field_1005).count() : 1L))));
                consumer = LootTableHelper.applyFunctions(consumer, entry.field_996, globalFunction, context);
                entry.method_433(consumer, context);
            });
            Arrays.stream(entries).filter(entry -> entry instanceof class_83).map(entry -> (class_83)entry).map(entry -> LootTableHelper.getLoots(entry.field_993, server, context)).forEach(loots::addAll);
        }
        return loots;
    }

    private static Consumer<class_1799> applyFunctions(Consumer<class_1799> consumer, class_117[] functions, BiFunction<class_1799, class_47, class_1799> globalFunction, class_47 context) {
        for (class_117 function : functions) {
            consumer = class_117.method_513((BiFunction)function, consumer, (class_47)context);
        }
        return class_117.method_513(globalFunction, consumer, (class_47)context);
    }

    public static Map<class_2960, List<Pair<class_1799, Double>>> getLoots() {
        return lootsMap;
    }

    public static void receiveLoots(Map<class_2960, List<Pair<class_1799, Double>>> newLoots) {
        lootsMap = newLoots;
    }

    public static List<Pair<class_1799, Double>> getLootsForTable(class_2960 table) {
        return lootsMap.getOrDefault(table, Collections.emptyList());
    }
}

