/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    public static boolean writeMachineJSON(MinecraftServer server, CustomMachine machine) {
        if (server != null) {
            DataResult result = CustomMachine.CODEC.encodeStart(JsonOps.INSTANCE, machine);
            JsonElement json = (JsonElement)result.resultOrPartial(arg_0 -> ((Logger)CustomMachinery.LOGGER).error(arg_0)).orElseThrow(() -> new JsonParseException("Error while writing custom machine: " + machine.getLocation().getId() + " to JSON"));
            try {
                List<Path> paths = FileUtils.getCustomMachineJson(server, machine.getLocation().getId());
                for (Path path : paths) {
                    File file = new File(path.toUri());
                    file.getParentFile().mkdirs();
                    CustomMachinery.LOGGER.info("Writing machine: " + machine.getLocation().getId() + " to: " + file.getPath());
                    if (!file.exists() && !file.createNewFile()) continue;
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    JsonWriter writer = gson.newJsonWriter((Writer)new FileWriter(file));
                    gson.toJson(json, writer);
                    writer.close();
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean deleteMachineJSON(MinecraftServer server, class_2960 location) {
        if (server == null) {
            return false;
        }
        class_2960 trueLocation = new class_2960(location.method_12836(), "machines/" + location.method_12832() + ".json");
        for (class_3262 pack : server.method_34864().method_29213().toList()) {
            File file;
            Path path;
            if (!pack.method_14411(class_3264.field_14190, trueLocation)) continue;
            if (pack instanceof class_3258) {
                class_3258 filePackResources = (class_3258)pack;
                filePackResources.close();
                Path zipPath = Platform.getGameFolder().resolve(filePackResources.field_14181.toString().substring(2));
                try (FileSystem zipfs = FileSystems.newFileSystem(zipPath, Map.of("create", "false"));){
                    Path path2 = zipfs.getPath("data/" + trueLocation.method_12836() + "/" + trueLocation.method_12832(), new String[0]);
                    if (Files.exists(path2, new LinkOption[0])) {
                        Files.delete(path2);
                        CustomMachinery.LOGGER.info("Deleted custom machine json for id {} in zip archive {}", (Object)location, (Object)zipPath);
                    }
                }
                catch (IOException e) {
                    CustomMachinery.LOGGER.error(e.getMessage(), (Throwable)e);
                }
                try {
                    filePackResources.method_14399();
                }
                catch (IOException e) {}
                continue;
            }
            if (pack instanceof class_3255) {
                class_3255 packResources = (class_3255)pack;
                path = Platform.getGameFolder().resolve(packResources.field_14181.toString().substring(2)).resolve("data/" + trueLocation.method_12836() + "/" + trueLocation.method_12832());
                file = new File(path.toUri());
                if (!file.exists() || !file.isFile() || !file.delete()) continue;
                CustomMachinery.LOGGER.info("Deleted custom machine json for id {} at path {}", (Object)location, (Object)path);
                continue;
            }
            if (!pack.method_14409().contains("KubeJS") || !(file = new File((path = KubeJSIntegration.getMachineJsonPath(trueLocation)).toUri())).exists() || !file.isFile() || !file.delete()) continue;
            CustomMachinery.LOGGER.info("Deleted custom machine json for id {} at path {}", (Object)location, (Object)path);
        }
        return false;
    }

    public static List<Path> getCustomMachineJson(MinecraftServer server, class_2960 location) {
        class_2960 trueLocation = new class_2960(location.method_12836(), "machines/" + location.method_12832() + ".json");
        ArrayList<Path> paths = new ArrayList<Path>();
        for (class_3262 pack : server.method_34864().method_29213().toList()) {
            if (!pack.method_14411(class_3264.field_14190, trueLocation) || !pack.method_14409().contains("KubeJS")) continue;
            paths.add(KubeJSIntegration.getMachineJsonPath(trueLocation));
        }
        return paths;
    }
}

