/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import fr.frinn.custommachinery.CustomMachinery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.Logger;

public abstract class CustomJsonReloadListener
extends class_4080<Map<class_2960, JsonElement>> {
    private static final Gson GSON = new GsonBuilder().create();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private static final Logger LOGGER = CustomMachinery.LOGGER;
    private final String directory;

    public CustomJsonReloadListener(String string) {
        this.directory = string;
    }

    protected Map<class_2960, JsonElement> prepare(class_3300 manager, class_3695 profiler) {
        LOGGER.info("Parsing all .json files in {} folder.", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (class_2960 loc2 : manager.method_14488(this.directory, loc -> loc.endsWith(".json"))) {
            String path = loc2.method_12832();
            class_2960 id = new class_2960(loc2.method_12836(), path.substring(i, path.length() - PATH_SUFFIX_LENGTH));
            try {
                class_3298 resource = manager.method_14486(loc2);
                try {
                    InputStream inputStream = resource.method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (jsonElement != null) {
                            JsonElement replaced = map.put(id, jsonElement);
                            if (replaced == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)loc2);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Couldn't parse data file {} from {}\n{}", (Object)id, (Object)loc2, (Object)e);
            }
        }
        LOGGER.info("Finished, {} .json files successfully parsed in {} folder.", (Object)map.size(), (Object)this.directory);
        return map;
    }
}

