/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import java.util.Comparator;
import java.util.Locale;
import java.util.stream.Stream;

public enum ComparatorMode {
    GREATER(">>"),
    GREATER_OR_EQUALS(">="),
    EQUALS("=="),
    LESSER_OR_EQUALS("<="),
    LESSER("<<");

    public static final NamedCodec<ComparatorMode> CODEC;
    private final String prefix;

    private ComparatorMode(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public <T> boolean compare(T first, T second, Comparator<T> comparator) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GREATER -> {
                if (comparator.compare(first, second) > 0) {
                    yield true;
                }
                yield false;
            }
            case GREATER_OR_EQUALS -> {
                if (comparator.compare(first, second) >= 0) {
                    yield true;
                }
                yield false;
            }
            case EQUALS -> {
                if (comparator.compare(first, second) == 0) {
                    yield true;
                }
                yield false;
            }
            case LESSER_OR_EQUALS -> {
                if (comparator.compare(first, second) <= 0) {
                    yield true;
                }
                yield false;
            }
            case LESSER -> comparator.compare(first, second) < 0;
        };
    }

    public <T extends Comparable<T>> boolean compare(T first, T second) {
        return this.compare(first, second, Comparator.naturalOrder());
    }

    public String getTranslationKey() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GREATER -> "custommachinery.comparator.greater";
            case GREATER_OR_EQUALS -> "custommachinery.comparator.greater_or_equals";
            case EQUALS -> "custommachinery.comparator.equals";
            case LESSER_OR_EQUALS -> "custommachinery.comparator.lesser_or_equals";
            case LESSER -> "custommachinery.comparator.lesser";
        };
    }

    public static ComparatorMode value(String value) {
        try {
            return ComparatorMode.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return Stream.of(ComparatorMode.values()).filter(comparatorMode -> comparatorMode.prefix.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid Comparator Mode: " + value));
        }
    }

    static {
        CODEC = NamedCodec.STRING.comapFlatMap(s -> {
            try {
                return DataResult.success((Object)((Object)ComparatorMode.value(s)));
            }
            catch (IllegalArgumentException e) {
                return DataResult.error((String)e.getMessage());
            }
        }, ComparatorMode::getPrefix, "Comparator mode");
    }
}

